@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ApplicationVersion].
 */
@PulumiTagMarker
public class ApplicationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationVersionArgs = ApplicationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationVersionArgsBuilder.() -> Unit) {
        val builder = ApplicationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApplicationVersion {
        val builtJavaResource =
            com.pulumi.aws.elasticbeanstalk.ApplicationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationVersion(builtJavaResource)
    }
}

/**
 * Provides an Elastic Beanstalk Application Version Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * This resource creates a Beanstalk Application Version that can be deployed to a Beanstalk
 * Environment.
 * > **NOTE on Application Version Resource:**  When using the Application Version resource with multiple
 * Elastic Beanstalk Environments it is possible that an error may be returned
 * when attempting to delete an Application Version while it is still in use by a different environment.
 * To work around this you can either create each environment in a separate AWS account or create your `aws.elasticbeanstalk.ApplicationVersion` resources with a unique names in your Elastic Beanstalk Application. For example &lt;revision&gt;-&lt;environment&gt;.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersion;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultBucketV2 = new BucketV2("defaultBucketV2");
 *         var defaultBucketObjectv2 = new BucketObjectv2("defaultBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(defaultBucketV2.id())
 *             .key("beanstalk/go-v1.zip")
 *             .source(new FileAsset("go-v1.zip"))
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .description("tf-test-desc")
 *             .build());
 *         var defaultApplicationVersion = new ApplicationVersion("defaultApplicationVersion", ApplicationVersionArgs.builder()
 *             .application("tf-test-name")
 *             .description("application version")
 *             .bucket(defaultBucketV2.id())
 *             .key(defaultBucketObjectv2.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class ApplicationVersion internal constructor(
    override val javaResource: com.pulumi.aws.elasticbeanstalk.ApplicationVersion,
) : KotlinCustomResource(javaResource, ApplicationVersionMapper) {
    /**
     * Name of the Beanstalk Application the version is associated with.
     */
    public val application: Output<String>
        get() = javaResource.application().applyValue({ args0 -> args0 })

    /**
     * ARN assigned by AWS for this Elastic Beanstalk Application.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * S3 bucket that contains the Application Version source bundle.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Short description of the Application Version.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 object that is the Application Version source bundle.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Unique name for the this Application Version.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ApplicationVersionMapper : ResourceMapper<ApplicationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticbeanstalk.ApplicationVersion::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationVersion = ApplicationVersion(
        javaResource as
            com.pulumi.aws.elasticbeanstalk.ApplicationVersion,
    )
}

/**
 * @see [ApplicationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationVersion].
 */
public suspend fun applicationVersion(
    name: String,
    block: suspend ApplicationVersionResourceBuilder.() -> Unit,
): ApplicationVersion {
    val builder = ApplicationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationVersion(name: String): ApplicationVersion {
    val builder = ApplicationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
