@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Beanstalk Application Version Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * This resource creates a Beanstalk Application Version that can be deployed to a Beanstalk
 * Environment.
 * > **NOTE on Application Version Resource:**  When using the Application Version resource with multiple
 * Elastic Beanstalk Environments it is possible that an error may be returned
 * when attempting to delete an Application Version while it is still in use by a different environment.
 * To work around this you can either create each environment in a separate AWS account or create your `aws.elasticbeanstalk.ApplicationVersion` resources with a unique names in your Elastic Beanstalk Application. For example &lt;revision&gt;-&lt;environment&gt;.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersion;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultBucketV2 = new BucketV2("defaultBucketV2");
 *         var defaultBucketObjectv2 = new BucketObjectv2("defaultBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(defaultBucketV2.id())
 *             .key("beanstalk/go-v1.zip")
 *             .source(new FileAsset("go-v1.zip"))
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .description("tf-test-desc")
 *             .build());
 *         var defaultApplicationVersion = new ApplicationVersion("defaultApplicationVersion", ApplicationVersionArgs.builder()
 *             .application("tf-test-name")
 *             .description("application version")
 *             .bucket(defaultBucketV2.id())
 *             .key(defaultBucketObjectv2.id())
 *             .build());
 *     }
 * }
 * ```
 * @property application Name of the Beanstalk Application the version is associated with.
 * @property bucket S3 bucket that contains the Application Version source bundle.
 * @property description Short description of the Application Version.
 * @property forceDelete On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
 * @property key S3 object that is the Application Version source bundle.
 * @property name Unique name for the this Application Version.
 * The following arguments are optional:
 * @property tags Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ApplicationVersionArgs(
    public val application: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val description: Output<String>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs =
        com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs.builder()
            .application(application?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationVersionArgs].
 */
@PulumiTagMarker
public class ApplicationVersionArgsBuilder internal constructor() {
    private var application: Output<String>? = null

    private var bucket: Output<String>? = null

    private var description: Output<String>? = null

    private var forceDelete: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Beanstalk Application the version is associated with.
     */
    @JvmName("srdihiqsbfujmegw")
    public suspend fun application(`value`: Output<String>) {
        this.application = value
    }

    /**
     * @param value S3 bucket that contains the Application Version source bundle.
     */
    @JvmName("tneogjrnvadcsgle")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Short description of the Application Version.
     */
    @JvmName("xdxnauoqnlecsiha")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
     */
    @JvmName("miioknyaerdvgaqs")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value S3 object that is the Application Version source bundle.
     */
    @JvmName("idtukvdspecrmifh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Unique name for the this Application Version.
     * The following arguments are optional:
     */
    @JvmName("gjairurswlxlfyrx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oxosvwnmomyyxvuq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Beanstalk Application the version is associated with.
     */
    @JvmName("jgxdjxeojqdjpwxs")
    public suspend fun application(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.application = mapped
    }

    /**
     * @param value S3 bucket that contains the Application Version source bundle.
     */
    @JvmName("wjfsuyxdaodmkduo")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Short description of the Application Version.
     */
    @JvmName("xpqcabnyhgwbpnid")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
     */
    @JvmName("tpcxhifqtknlttpf")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value S3 object that is the Application Version source bundle.
     */
    @JvmName("vwvhxqrwvlxepkpo")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Unique name for the this Application Version.
     * The following arguments are optional:
     */
    @JvmName("ibpjpnxigajdqrwg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("npwjkkrdowhvrbsy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("noclivdcjsodybop")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationVersionArgs = ApplicationVersionArgs(
        application = application,
        bucket = bucket,
        description = description,
        forceDelete = forceDelete,
        key = key,
        name = name,
        tags = tags,
    )
}
