@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.EnvironmentArgs.builder
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.EnvironmentSettingArgs
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.EnvironmentSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Beanstalk Environment Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * Environments are often things such as `development`, `integration`, or
 * `production`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.Environment;
 * import com.pulumi.aws.elasticbeanstalk.EnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .description("tf-test-desc")
 *             .build());
 *         var tfenvtest = new Environment("tfenvtest", EnvironmentArgs.builder()
 *             .application(tftest.name())
 *             .solutionStackName("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Option Settings
 * Some options can be stack-specific, check [AWS Docs](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html)
 * for supported options and examples.
 * The `setting` and `all_settings` mappings support the following format:
 * * `namespace` - unique namespace identifying the option's associated AWS resource
 * * `name` - name of the configuration option
 * * `value` - value for the configuration option
 * * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)
 * ### Example With Options
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tftest = new aws.elasticbeanstalk.Application("tftest", {description: "tf-test-desc"});
 * const tfenvtest = new aws.elasticbeanstalk.Environment("tfenvtest", {
 *     application: tftest.name,
 *     solutionStackName: "64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *     settings: [
 *         {
 *             namespace: "aws:ec2:vpc",
 *             name: "VPCId",
 *             value: "vpc-xxxxxxxx",
 *         },
 *         {
 *             namespace: "aws:ec2:vpc",
 *             name: "Subnets",
 *             value: "subnet-xxxxxxxx",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tftest = aws.elasticbeanstalk.Application("tftest", description="tf-test-desc")
 * tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
 *     application=tftest.name,
 *     solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *     settings=[
 *         aws.elasticbeanstalk.EnvironmentSettingArgs(
 *             namespace="aws:ec2:vpc",
 *             name="VPCId",
 *             value="vpc-xxxxxxxx",
 *         ),
 *         aws.elasticbeanstalk.EnvironmentSettingArgs(
 *             namespace="aws:ec2:vpc",
 *             name="Subnets",
 *             value="subnet-xxxxxxxx",
 *         ),
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tftest = new Aws.ElasticBeanstalk.Application("tftest", new()
 *     {
 *         Description = "tf-test-desc",
 *     });
 *     var tfenvtest = new Aws.ElasticBeanstalk.Environment("tfenvtest", new()
 *     {
 *         Application = tftest.Name,
 *         SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *         Settings = new[]
 *         {
 *             new Aws.ElasticBeanstalk.Inputs.EnvironmentSettingArgs
 *             {
 *                 Namespace = "aws:ec2:vpc",
 *                 Name = "VPCId",
 *                 Value = "vpc-xxxxxxxx",
 *             },
 *             new Aws.ElasticBeanstalk.Inputs.EnvironmentSettingArgs
 *             {
 *                 Namespace = "aws:ec2:vpc",
 *                 Name = "Subnets",
 *                 Value = "subnet-xxxxxxxx",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tftest, err := elasticbeanstalk.NewApplication(ctx, "tftest", &elasticbeanstalk.ApplicationArgs{
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewEnvironment(ctx, "tfenvtest", &elasticbeanstalk.EnvironmentArgs{
 * 			Application:       tftest.Name,
 * 			SolutionStackName: pulumi.String("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4"),
 * 			Settings: elasticbeanstalk.EnvironmentSettingArray{
 * 				&elasticbeanstalk.EnvironmentSettingArgs{
 * 					Namespace: pulumi.String("aws:ec2:vpc"),
 * 					Name:      pulumi.String("VPCId"),
 * 					Value:     pulumi.String("vpc-xxxxxxxx"),
 * 				},
 * 				&elasticbeanstalk.EnvironmentSettingArgs{
 * 					Namespace: pulumi.String("aws:ec2:vpc"),
 * 					Name:      pulumi.String("Subnets"),
 * 					Value:     pulumi.String("subnet-xxxxxxxx"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.Environment;
 * import com.pulumi.aws.elasticbeanstalk.EnvironmentArgs;
 * import com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .description("tf-test-desc")
 *             .build());
 *         var tfenvtest = new Environment("tfenvtest", EnvironmentArgs.builder()
 *             .application(tftest.name())
 *             .solutionStackName("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
 *             .settings(
 *                 EnvironmentSettingArgs.builder()
 *                     .namespace("aws:ec2:vpc")
 *                     .name("VPCId")
 *                     .value("vpc-xxxxxxxx")
 *                     .build(),
 *                 EnvironmentSettingArgs.builder()
 *                     .namespace("aws:ec2:vpc")
 *                     .name("Subnets")
 *                     .value("subnet-xxxxxxxx")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tftest:
 *     type: aws:elasticbeanstalk:Application
 *     properties:
 *       description: tf-test-desc
 *   tfenvtest:
 *     type: aws:elasticbeanstalk:Environment
 *     properties:
 *       application: ${tftest.name}
 *       solutionStackName: 64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4
 *       settings:
 *         - namespace: aws:ec2:vpc
 *           name: VPCId
 *           value: vpc-xxxxxxxx
 *         - namespace: aws:ec2:vpc
 *           name: Subnets
 *           value: subnet-xxxxxxxx
 * ```
 * ## Import
 * Using `pulumi import`, import Elastic Beanstalk Environments using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticbeanstalk/environment:Environment prodenv e-rpqsewtp2j
 * ```
 * @property application Name of the application that contains the version
 * to be deployed
 * @property cnamePrefix Prefix to use for the fully qualified DNS name of
 * the Environment.
 * @property description Short description of the Environment
 * @property name A unique name for this Environment. This name is used
 * in the application URL
 * @property platformArn The [ARN](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/aws-arns-and-namespaces&#46;html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
 * to use in deployment
 * @property pollInterval The time between polling the AWS API to
 * check if changes have been applied. Use this to adjust the rate of API calls
 * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
 * use the default behavior, which is an exponential backoff
 * @property settings Option settings to configure the new Environment. These
 * override specific values that are set as defaults. The format is detailed
 * below in Option Settings
 * @property solutionStackName A solution stack to base your environment
 * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
 * @property tags A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateName The name of the Elastic Beanstalk Configuration
 * template to use in deployment
 * @property tier Elastic Beanstalk Environment tier. Valid values are `Worker`
 * or `WebServer`. If tier is left blank `WebServer` will be used.
 * @property version The name of the Elastic Beanstalk Application Version
 * to use in deployment.
 * @property waitForReadyTimeout The maximum
 * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
 * wait for an Elastic Beanstalk Environment to be in a ready state before timing
 * out.
 */
public data class EnvironmentArgs(
    public val application: Output<String>? = null,
    public val cnamePrefix: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val platformArn: Output<String>? = null,
    public val pollInterval: Output<String>? = null,
    public val settings: Output<List<EnvironmentSettingArgs>>? = null,
    public val solutionStackName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateName: Output<String>? = null,
    public val tier: Output<String>? = null,
    public val version: Output<String>? = null,
    public val waitForReadyTimeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.EnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.EnvironmentArgs =
        com.pulumi.aws.elasticbeanstalk.EnvironmentArgs.builder()
            .application(application?.applyValue({ args0 -> args0 }))
            .cnamePrefix(cnamePrefix?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .platformArn(platformArn?.applyValue({ args0 -> args0 }))
            .pollInterval(pollInterval?.applyValue({ args0 -> args0 }))
            .settings(
                settings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .solutionStackName(solutionStackName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .waitForReadyTimeout(waitForReadyTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var application: Output<String>? = null

    private var cnamePrefix: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var platformArn: Output<String>? = null

    private var pollInterval: Output<String>? = null

    private var settings: Output<List<EnvironmentSettingArgs>>? = null

    private var solutionStackName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateName: Output<String>? = null

    private var tier: Output<String>? = null

    private var version: Output<String>? = null

    private var waitForReadyTimeout: Output<String>? = null

    /**
     * @param value Name of the application that contains the version
     * to be deployed
     */
    @JvmName("iibelppllwobxieq")
    public suspend fun application(`value`: Output<String>) {
        this.application = value
    }

    /**
     * @param value Prefix to use for the fully qualified DNS name of
     * the Environment.
     */
    @JvmName("rtdovilttcnkuapd")
    public suspend fun cnamePrefix(`value`: Output<String>) {
        this.cnamePrefix = value
    }

    /**
     * @param value Short description of the Environment
     */
    @JvmName("rhllrsgummojuudi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A unique name for this Environment. This name is used
     * in the application URL
     */
    @JvmName("ogdkclhdombmjjwt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The [ARN](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/aws-arns-and-namespaces&#46;html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
     * to use in deployment
     */
    @JvmName("grmmrqykvbwwyhdw")
    public suspend fun platformArn(`value`: Output<String>) {
        this.platformArn = value
    }

    /**
     * @param value The time between polling the AWS API to
     * check if changes have been applied. Use this to adjust the rate of API calls
     * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
     * use the default behavior, which is an exponential backoff
     */
    @JvmName("qnpkwgpqccccghfp")
    public suspend fun pollInterval(`value`: Output<String>) {
        this.pollInterval = value
    }

    /**
     * @param value Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("lrgsuywrxegowdxo")
    public suspend fun settings(`value`: Output<List<EnvironmentSettingArgs>>) {
        this.settings = value
    }

    @JvmName("aqflngueemcrbtak")
    public suspend fun settings(vararg values: Output<EnvironmentSettingArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("fgxuoiurqifxabmi")
    public suspend fun settings(values: List<Output<EnvironmentSettingArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value A solution stack to base your environment
     * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
     */
    @JvmName("etomyoovpdnnhwpt")
    public suspend fun solutionStackName(`value`: Output<String>) {
        this.solutionStackName = value
    }

    /**
     * @param value A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pbofecqjxoitkvcw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Elastic Beanstalk Configuration
     * template to use in deployment
     */
    @JvmName("bxobrarxdjwalqmm")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value Elastic Beanstalk Environment tier. Valid values are `Worker`
     * or `WebServer`. If tier is left blank `WebServer` will be used.
     */
    @JvmName("cnlhbstghkdgcarp")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The name of the Elastic Beanstalk Application Version
     * to use in deployment.
     */
    @JvmName("ljdldxpjmelagyuf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
     * wait for an Elastic Beanstalk Environment to be in a ready state before timing
     * out.
     */
    @JvmName("wweawiycorhejovg")
    public suspend fun waitForReadyTimeout(`value`: Output<String>) {
        this.waitForReadyTimeout = value
    }

    /**
     * @param value Name of the application that contains the version
     * to be deployed
     */
    @JvmName("xujayrvdewvlyojo")
    public suspend fun application(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.application = mapped
    }

    /**
     * @param value Prefix to use for the fully qualified DNS name of
     * the Environment.
     */
    @JvmName("tkvxbtpufruankdt")
    public suspend fun cnamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnamePrefix = mapped
    }

    /**
     * @param value Short description of the Environment
     */
    @JvmName("rhibjglgqmervccs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A unique name for this Environment. This name is used
     * in the application URL
     */
    @JvmName("fhohgpnnrohgqwlb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The [ARN](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/aws-arns-and-namespaces&#46;html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
     * to use in deployment
     */
    @JvmName("gkjhmedxrwjmxwjy")
    public suspend fun platformArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformArn = mapped
    }

    /**
     * @param value The time between polling the AWS API to
     * check if changes have been applied. Use this to adjust the rate of API calls
     * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
     * use the default behavior, which is an exponential backoff
     */
    @JvmName("pdwcnfdglnhxwnwe")
    public suspend fun pollInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollInterval = mapped
    }

    /**
     * @param value Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("lgmeiachsryepijd")
    public suspend fun settings(`value`: List<EnvironmentSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("qclrglvthccuseyu")
    public suspend fun settings(argument: List<suspend EnvironmentSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("ysmfcetrnkvrnusg")
    public suspend fun settings(vararg argument: suspend EnvironmentSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("vahqwlfkqjchcynt")
    public suspend fun settings(argument: suspend EnvironmentSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("xfuojfivvggvfakv")
    public suspend fun settings(vararg values: EnvironmentSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value A solution stack to base your environment
     * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
     */
    @JvmName("lqfnxpvbppagpxdp")
    public suspend fun solutionStackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionStackName = mapped
    }

    /**
     * @param value A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iahomohhvuajrnbt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nugjeemoouhvuqcl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the Elastic Beanstalk Configuration
     * template to use in deployment
     */
    @JvmName("pmjaimrdwglxtuoi")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value Elastic Beanstalk Environment tier. Valid values are `Worker`
     * or `WebServer`. If tier is left blank `WebServer` will be used.
     */
    @JvmName("smgsibwfhqjrexfa")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Elastic Beanstalk Application Version
     * to use in deployment.
     */
    @JvmName("mkothuaoajipykll")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
     * wait for an Elastic Beanstalk Environment to be in a ready state before timing
     * out.
     */
    @JvmName("cwwhiouxqvqebckb")
    public suspend fun waitForReadyTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForReadyTimeout = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        application = application,
        cnamePrefix = cnamePrefix,
        description = description,
        name = name,
        platformArn = platformArn,
        pollInterval = pollInterval,
        settings = settings,
        solutionStackName = solutionStackName,
        tags = tags,
        templateName = templateName,
        tier = tier,
        version = version,
        waitForReadyTimeout = waitForReadyTimeout,
    )
}
