@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.inputs

import com.pulumi.aws.elasticbeanstalk.inputs.ConfigurationTemplateSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name A unique name for this Template.
 * @property namespace
 * @property resource
 * @property value
 */
public data class ConfigurationTemplateSettingArgs(
    public val name: Output<String>,
    public val namespace: Output<String>,
    public val resource: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.inputs.ConfigurationTemplateSettingArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.inputs.ConfigurationTemplateSettingArgs =
        com.pulumi.aws.elasticbeanstalk.inputs.ConfigurationTemplateSettingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 }))
            .resource(resource?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationTemplateSettingArgs].
 */
@PulumiTagMarker
public class ConfigurationTemplateSettingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var resource: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value A unique name for this Template.
     */
    @JvmName("ldghsnmysnpmfnyr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("qwweflcrjsgndnav")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value
     */
    @JvmName("vifjfhtujdjktkgq")
    public suspend fun resource(`value`: Output<String>) {
        this.resource = value
    }

    /**
     * @param value
     */
    @JvmName("ikisavduyxbrjfsd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value A unique name for this Template.
     */
    @JvmName("foifruxwsechcvgo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ibkocgdikdsgyffv")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value
     */
    @JvmName("vihaekprydvrkhoo")
    public suspend fun resource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param value
     */
    @JvmName("ebwkmvoveaxfbbmj")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConfigurationTemplateSettingArgs = ConfigurationTemplateSettingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        resource = resource,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
