@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.inputs

import com.pulumi.aws.elasticbeanstalk.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplication.
 * @property name Name of the application
 */
public data class GetApplicationPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.inputs.GetApplicationPlainArgs =
        com.pulumi.aws.elasticbeanstalk.inputs.GetApplicationPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the application
     */
    @JvmName("bvfbwkeodjaipyux")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
