@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.inputs

import com.pulumi.aws.elasticbeanstalk.inputs.GetSolutionStackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSolutionStack.
 * @property mostRecent If more than one result is returned, use the most
 * recent solution stack.
 * @property nameRegex Regex string to apply to the solution stack list returned
 * by AWS. See [Elastic Beanstalk Supported Platforms][beanstalk-platforms] from
 * AWS documentation for reference solution stack names.
 * > **NOTE:** If more or less than a single match is returned by the search,
 * this call will fail. Ensure that your search is specific enough to return
 * a single solution stack, or use `most_recent` to choose the most recent one.
 */
public data class GetSolutionStackPlainArgs(
    public val mostRecent: Boolean? = null,
    public val nameRegex: String,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.inputs.GetSolutionStackPlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.inputs.GetSolutionStackPlainArgs =
        com.pulumi.aws.elasticbeanstalk.inputs.GetSolutionStackPlainArgs.builder()
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .nameRegex(nameRegex.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSolutionStackPlainArgs].
 */
@PulumiTagMarker
public class GetSolutionStackPlainArgsBuilder internal constructor() {
    private var mostRecent: Boolean? = null

    private var nameRegex: String? = null

    /**
     * @param value If more than one result is returned, use the most
     * recent solution stack.
     */
    @JvmName("xmkflialdyewrmdy")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Regex string to apply to the solution stack list returned
     * by AWS. See [Elastic Beanstalk Supported Platforms][beanstalk-platforms] from
     * AWS documentation for reference solution stack names.
     * > **NOTE:** If more or less than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single solution stack, or use `most_recent` to choose the most recent one.
     */
    @JvmName("mubhdaixgvnlltgv")
    public suspend fun nameRegex(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    internal fun build(): GetSolutionStackPlainArgs = GetSolutionStackPlainArgs(
        mostRecent = mostRecent,
        nameRegex = nameRegex ?: throw PulumiNullFieldException("nameRegex"),
    )
}
