@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteSourceFromS3 Set to `true` to delete a version's source bundle from S3 when the application version is deleted.
 * @property maxAgeInDays The number of days to retain an application version ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
 * @property maxCount The maximum number of application versions to retain ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
 * @property serviceRole The ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
 */
public data class ApplicationAppversionLifecycle(
    public val deleteSourceFromS3: Boolean? = null,
    public val maxAgeInDays: Int? = null,
    public val maxCount: Int? = null,
    public val serviceRole: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.ApplicationAppversionLifecycle):
            ApplicationAppversionLifecycle = ApplicationAppversionLifecycle(
            deleteSourceFromS3 = javaType.deleteSourceFromS3().map({ args0 -> args0 }).orElse(null),
            maxAgeInDays = javaType.maxAgeInDays().map({ args0 -> args0 }).orElse(null),
            maxCount = javaType.maxCount().map({ args0 -> args0 }).orElse(null),
            serviceRole = javaType.serviceRole(),
        )
    }
}
