@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name A unique name for this Template.
 * @property namespace
 * @property resource
 * @property value
 */
public data class ConfigurationTemplateSetting(
    public val name: String,
    public val namespace: String,
    public val resource: String? = null,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.ConfigurationTemplateSetting):
            ConfigurationTemplateSetting = ConfigurationTemplateSetting(
            name = javaType.name(),
            namespace = javaType.namespace(),
            resource = javaType.resource().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
