@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteSourceFromS3 Specifies whether delete a version's source bundle from S3 when the application version is deleted.
 * @property maxAgeInDays Number of days to retain an application version.
 * @property maxCount Maximum number of application versions to retain.
 * @property serviceRole ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
 */
public data class GetApplicationAppversionLifecycle(
    public val deleteSourceFromS3: Boolean,
    public val maxAgeInDays: Int,
    public val maxCount: Int,
    public val serviceRole: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.GetApplicationAppversionLifecycle):
            GetApplicationAppversionLifecycle = GetApplicationAppversionLifecycle(
            deleteSourceFromS3 = javaType.deleteSourceFromS3(),
            maxAgeInDays = javaType.maxAgeInDays(),
            maxCount = javaType.maxCount(),
            serviceRole = javaType.serviceRole(),
        )
    }
}
