@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getSolutionStack.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property mostRecent
 * @property name Name of the solution stack.
 * @property nameRegex
 */
public data class GetSolutionStackResult(
    public val id: String,
    public val mostRecent: Boolean? = null,
    public val name: String,
    public val nameRegex: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.GetSolutionStackResult):
            GetSolutionStackResult = GetSolutionStackResult(
            id = javaType.id(),
            mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nameRegex = javaType.nameRegex(),
        )
    }
}
