@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin

import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainAdvancedSecurityOptions
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainAutoTuneOptions
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainClusterConfig
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainCognitoOptions
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainDomainEndpointOptions
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainEbsOptions
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainEncryptAtRest
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainLogPublishingOption
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainNodeToNodeEncryption
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainSnapshotOptions
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainVpcOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainAdvancedSecurityOptions.Companion.toKotlin as domainAdvancedSecurityOptionsToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainAutoTuneOptions.Companion.toKotlin as domainAutoTuneOptionsToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainClusterConfig.Companion.toKotlin as domainClusterConfigToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainCognitoOptions.Companion.toKotlin as domainCognitoOptionsToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainDomainEndpointOptions.Companion.toKotlin as domainDomainEndpointOptionsToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainEbsOptions.Companion.toKotlin as domainEbsOptionsToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainEncryptAtRest.Companion.toKotlin as domainEncryptAtRestToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainLogPublishingOption.Companion.toKotlin as domainLogPublishingOptionToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainNodeToNodeEncryption.Companion.toKotlin as domainNodeToNodeEncryptionToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainSnapshotOptions.Companion.toKotlin as domainSnapshotOptionsToKotlin
import com.pulumi.aws.elasticsearch.kotlin.outputs.DomainVpcOptions.Companion.toKotlin as domainVpcOptionsToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.elasticsearch.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Manages an AWS Elasticsearch Domain.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.elasticsearch")
 *                 .build())
 *             .elasticsearchVersion("7.10")
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build());
 *     }
 * }
 * ```
 * ### Access Policy
 * > See also: `aws.elasticsearch.DomainPolicy` resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domain = config.get("domain").orElse("tf-test");
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var example = new Domain("example", DomainArgs.builder()
 *             .accessPolicies("""
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Action": "es:*",
 *       "Principal": "*",
 *       "Effect": "Allow",
 *       "Resource": "arn:aws:es:%s:%s:domain/%s/*",
 *       "Condition": {
 *         "IpAddress": {"aws:SourceIp": ["66.193.100.22/32"]}
 *       }
 *     }
 *   ]
 * }
 * ", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),domain))
 *             .build());
 *     }
 * }
 * ```
 * ### Log Publishing to CloudWatch Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainLogPublishingOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("es.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "logs:PutLogEvents",
 *                     "logs:PutLogEventsBatch",
 *                     "logs:CreateLogStream")
 *                 .resources("arn:aws:logs:*")
 *                 .build())
 *             .build());
 *         var exampleLogResourcePolicy = new LogResourcePolicy("exampleLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyName("example")
 *             .policyDocument(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .logPublishingOptions(DomainLogPublishingOptionArgs.builder()
 *                 .cloudwatchLogGroupArn(exampleLogGroup.arn())
 *                 .logType("INDEX_SLOW_LOGS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### VPC based ES
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetVpcArgs;
 * import com.pulumi.aws.ec2.inputs.GetSubnetsArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
 * import com.pulumi.aws.iam.ServiceLinkedRole;
 * import com.pulumi.aws.iam.ServiceLinkedRoleArgs;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var vpc = config.get("vpc");
 *         final var domain = config.get("domain").orElse("tf-test");
 *         final var selectedVpc = Ec2Functions.getVpc(GetVpcArgs.builder()
 *             .tags(Map.of("Name", vpc))
 *             .build());
 *         final var selectedSubnets = Ec2Functions.getSubnets(GetSubnetsArgs.builder()
 *             .filters(GetSubnetsFilterArgs.builder()
 *                 .name("vpc-id")
 *                 .values(selectedVpc.applyValue(getVpcResult -> getVpcResult.id()))
 *                 .build())
 *             .tags(Map.of("Tier", "private"))
 *             .build());
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var esSecurityGroup = new SecurityGroup("esSecurityGroup", SecurityGroupArgs.builder()
 *             .description("Managed by Pulumi")
 *             .vpcId(selectedVpc.applyValue(getVpcResult -> getVpcResult.id()))
 *             .ingress(SecurityGroupIngressArgs.builder()
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .protocol("tcp")
 *                 .cidrBlocks(selectedVpc.applyValue(getVpcResult -> getVpcResult.cidrBlock()))
 *                 .build())
 *             .build());
 *         var esServiceLinkedRole = new ServiceLinkedRole("esServiceLinkedRole", ServiceLinkedRoleArgs.builder()
 *             .awsServiceName("opensearchservice.amazonaws.com")
 *             .build());
 *         var esDomain = new Domain("esDomain", DomainArgs.builder()
 *             .elasticsearchVersion("6.3")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("m4.large.elasticsearch")
 *                 .zoneAwarenessEnabled(true)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .subnetIds(
 *                     selectedSubnets.applyValue(getSubnetsResult -> getSubnetsResult.ids()[0]),
 *                     selectedSubnets.applyValue(getSubnetsResult -> getSubnetsResult.ids()[1]))
 *                 .securityGroupIds(esSecurityGroup.id())
 *                 .build())
 *             .advancedOptions(Map.of("rest.action.multi.allow_explicit_index", "true"))
 *             .accessPolicies("""
 * {
 * 	"Version": "2012-10-17",
 * 	"Statement": [
 * 		{
 * 			"Action": "es:*",
 * 			"Principal": "*",
 * 			"Effect": "Allow",
 * 			"Resource": "arn:aws:es:%s:%s:domain/%s/*"
 * 		}
 * 	]
 * }
 * ", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),domain))
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(esServiceLinkedRole)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elasticsearch domains using the `domain_name`. For example:
 * ```sh
 *  $ pulumi import aws:elasticsearch/domain:Domain example domain_name
 * ```
 * */*/
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.elasticsearch.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * IAM policy document specifying the access policies for the domain.
     */
    public val accessPolicies: Output<String>
        get() = javaResource.accessPolicies().applyValue({ args0 -> args0 })

    /**
     * Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your Elasticsearch domain on every apply.
     */
    public val advancedOptions: Output<Map<String, String>>
        get() = javaResource.advancedOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for [fine-grained access control](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/fgac.html). Detailed below.
     */
    public val advancedSecurityOptions: Output<DomainAdvancedSecurityOptions>
        get() = javaResource.advancedSecurityOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainAdvancedSecurityOptionsToKotlin(args0)
            })
        })

    /**
     * ARN of the domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the Auto-Tune options of the domain. Detailed below.
     */
    public val autoTuneOptions: Output<DomainAutoTuneOptions>
        get() = javaResource.autoTuneOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainAutoTuneOptionsToKotlin(args0)
            })
        })

    /**
     * Configuration block for the cluster of the domain. Detailed below.
     */
    public val clusterConfig: Output<DomainClusterConfig>
        get() = javaResource.clusterConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                domainClusterConfigToKotlin(args0)
            })
        })

    /**
     * Configuration block for authenticating Kibana with Cognito. Detailed below.
     */
    public val cognitoOptions: Output<DomainCognitoOptions>?
        get() = javaResource.cognitoOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainCognitoOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for domain endpoint HTTP(S) related options. Detailed below.
     */
    public val domainEndpointOptions: Output<DomainDomainEndpointOptions>
        get() = javaResource.domainEndpointOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainDomainEndpointOptionsToKotlin(args0)
            })
        })

    /**
     * Unique identifier for the domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Name of the domain.
     * The following arguments are optional:
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/elasticsearch-service/pricing/). Detailed below.
     */
    public val ebsOptions: Output<DomainEbsOptions>
        get() = javaResource.ebsOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainEbsOptionsToKotlin(args0)
            })
        })

    /**
     * Version of Elasticsearch to deploy. Defaults to `1.5`.
     */
    public val elasticsearchVersion: Output<String>?
        get() = javaResource.elasticsearchVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for encrypt at rest options. Only available for [certain instance types](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html). Detailed below.
     */
    public val encryptAtRest: Output<DomainEncryptAtRest>
        get() = javaResource.encryptAtRest().applyValue({ args0 ->
            args0.let({ args0 ->
                domainEncryptAtRestToKotlin(args0)
            })
        })

    /**
     * Domain-specific endpoint used to submit index, search, and data upload requests.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Domain-specific endpoint for kibana without https scheme.
     */
    public val kibanaEndpoint: Output<String>
        get() = javaResource.kibanaEndpoint().applyValue({ args0 -> args0 })

    /**
     * Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    public val logPublishingOptions: Output<List<DomainLogPublishingOption>>?
        get() = javaResource.logPublishingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        domainLogPublishingOptionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for node-to-node encryption options. Detailed below.
     */
    public val nodeToNodeEncryption: Output<DomainNodeToNodeEncryption>
        get() = javaResource.nodeToNodeEncryption().applyValue({ args0 ->
            args0.let({ args0 ->
                domainNodeToNodeEncryptionToKotlin(args0)
            })
        })

    /**
     * Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running Elasticsearch 5.3 and later, Amazon ES takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions of Elasticsearch, Amazon ES takes daily automated snapshots.
     */
    public val snapshotOptions: Output<DomainSnapshotOptions>?
        get() = javaResource.snapshotOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainSnapshotOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * * `vpc_options.0.availability_zones` - If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
     * * `vpc_options.0.vpc_id` - If the domain was created inside a VPC, the ID of the VPC.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-vpc-limitations)). Detailed below.
     */
    public val vpcOptions: Output<DomainVpcOptions>?
        get() = javaResource.vpcOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainVpcOptionsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticsearch.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.elasticsearch.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
