@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin

import com.pulumi.aws.elasticsearch.DomainArgs.builder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainAdvancedSecurityOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainAdvancedSecurityOptionsArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainAutoTuneOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainAutoTuneOptionsArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainClusterConfigArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainClusterConfigArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainCognitoOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainCognitoOptionsArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainDomainEndpointOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainDomainEndpointOptionsArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainEbsOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainEbsOptionsArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainEncryptAtRestArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainEncryptAtRestArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainLogPublishingOptionArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainLogPublishingOptionArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainNodeToNodeEncryptionArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainNodeToNodeEncryptionArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainSnapshotOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainSnapshotOptionsArgsBuilder
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainVpcOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.DomainVpcOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Elasticsearch Domain.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.elasticsearch")
 *                 .build())
 *             .elasticsearchVersion("7.10")
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build());
 *     }
 * }
 * ```
 * ### Access Policy
 * > See also: `aws.elasticsearch.DomainPolicy` resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domain = config.get("domain").orElse("tf-test");
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var example = new Domain("example", DomainArgs.builder()
 *             .accessPolicies("""
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Action": "es:*",
 *       "Principal": "*",
 *       "Effect": "Allow",
 *       "Resource": "arn:aws:es:%s:%s:domain/%s/*",
 *       "Condition": {
 *         "IpAddress": {"aws:SourceIp": ["66.193.100.22/32"]}
 *       }
 *     }
 *   ]
 * }
 * ", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),domain))
 *             .build());
 *     }
 * }
 * ```
 * ### Log Publishing to CloudWatch Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainLogPublishingOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("es.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "logs:PutLogEvents",
 *                     "logs:PutLogEventsBatch",
 *                     "logs:CreateLogStream")
 *                 .resources("arn:aws:logs:*")
 *                 .build())
 *             .build());
 *         var exampleLogResourcePolicy = new LogResourcePolicy("exampleLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyName("example")
 *             .policyDocument(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .logPublishingOptions(DomainLogPublishingOptionArgs.builder()
 *                 .cloudwatchLogGroupArn(exampleLogGroup.arn())
 *                 .logType("INDEX_SLOW_LOGS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### VPC based ES
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetVpcArgs;
 * import com.pulumi.aws.ec2.inputs.GetSubnetsArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
 * import com.pulumi.aws.iam.ServiceLinkedRole;
 * import com.pulumi.aws.iam.ServiceLinkedRoleArgs;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var vpc = config.get("vpc");
 *         final var domain = config.get("domain").orElse("tf-test");
 *         final var selectedVpc = Ec2Functions.getVpc(GetVpcArgs.builder()
 *             .tags(Map.of("Name", vpc))
 *             .build());
 *         final var selectedSubnets = Ec2Functions.getSubnets(GetSubnetsArgs.builder()
 *             .filters(GetSubnetsFilterArgs.builder()
 *                 .name("vpc-id")
 *                 .values(selectedVpc.applyValue(getVpcResult -> getVpcResult.id()))
 *                 .build())
 *             .tags(Map.of("Tier", "private"))
 *             .build());
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var esSecurityGroup = new SecurityGroup("esSecurityGroup", SecurityGroupArgs.builder()
 *             .description("Managed by Pulumi")
 *             .vpcId(selectedVpc.applyValue(getVpcResult -> getVpcResult.id()))
 *             .ingress(SecurityGroupIngressArgs.builder()
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .protocol("tcp")
 *                 .cidrBlocks(selectedVpc.applyValue(getVpcResult -> getVpcResult.cidrBlock()))
 *                 .build())
 *             .build());
 *         var esServiceLinkedRole = new ServiceLinkedRole("esServiceLinkedRole", ServiceLinkedRoleArgs.builder()
 *             .awsServiceName("opensearchservice.amazonaws.com")
 *             .build());
 *         var esDomain = new Domain("esDomain", DomainArgs.builder()
 *             .elasticsearchVersion("6.3")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("m4.large.elasticsearch")
 *                 .zoneAwarenessEnabled(true)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .subnetIds(
 *                     selectedSubnets.applyValue(getSubnetsResult -> getSubnetsResult.ids()[0]),
 *                     selectedSubnets.applyValue(getSubnetsResult -> getSubnetsResult.ids()[1]))
 *                 .securityGroupIds(esSecurityGroup.id())
 *                 .build())
 *             .advancedOptions(Map.of("rest.action.multi.allow_explicit_index", "true"))
 *             .accessPolicies("""
 * {
 * 	"Version": "2012-10-17",
 * 	"Statement": [
 * 		{
 * 			"Action": "es:*",
 * 			"Principal": "*",
 * 			"Effect": "Allow",
 * 			"Resource": "arn:aws:es:%s:%s:domain/%s/*"
 * 		}
 * 	]
 * }
 * ", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),domain))
 *             .tags(Map.of("Domain", "TestDomain"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(esServiceLinkedRole)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elasticsearch domains using the `domain_name`. For example:
 * ```sh
 *  $ pulumi import aws:elasticsearch/domain:Domain example domain_name
 * ```
 * @property accessPolicies IAM policy document specifying the access policies for the domain.
 * @property advancedOptions Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your Elasticsearch domain on every apply.
 * @property advancedSecurityOptions Configuration block for [fine-grained access control](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/fgac.html). Detailed below.
 * @property autoTuneOptions Configuration block for the Auto-Tune options of the domain. Detailed below.
 * @property clusterConfig Configuration block for the cluster of the domain. Detailed below.
 * @property cognitoOptions Configuration block for authenticating Kibana with Cognito. Detailed below.
 * @property domainEndpointOptions Configuration block for domain endpoint HTTP(S) related options. Detailed below.
 * @property domainName Name of the domain.
 * The following arguments are optional:
 * @property ebsOptions Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/elasticsearch-service/pricing/). Detailed below.
 * @property elasticsearchVersion Version of Elasticsearch to deploy. Defaults to `1.5`.
 * @property encryptAtRest Configuration block for encrypt at rest options. Only available for [certain instance types](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html). Detailed below.
 * @property logPublishingOptions Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
 * @property nodeToNodeEncryption Configuration block for node-to-node encryption options. Detailed below.
 * @property snapshotOptions Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running Elasticsearch 5.3 and later, Amazon ES takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions of Elasticsearch, Amazon ES takes daily automated snapshots.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcOptions Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-vpc-limitations)). Detailed below.
 * */*/
 */
public data class DomainArgs(
    public val accessPolicies: Output<String>? = null,
    public val advancedOptions: Output<Map<String, String>>? = null,
    public val advancedSecurityOptions: Output<DomainAdvancedSecurityOptionsArgs>? = null,
    public val autoTuneOptions: Output<DomainAutoTuneOptionsArgs>? = null,
    public val clusterConfig: Output<DomainClusterConfigArgs>? = null,
    public val cognitoOptions: Output<DomainCognitoOptionsArgs>? = null,
    public val domainEndpointOptions: Output<DomainDomainEndpointOptionsArgs>? = null,
    public val domainName: Output<String>? = null,
    public val ebsOptions: Output<DomainEbsOptionsArgs>? = null,
    public val elasticsearchVersion: Output<String>? = null,
    public val encryptAtRest: Output<DomainEncryptAtRestArgs>? = null,
    public val logPublishingOptions: Output<List<DomainLogPublishingOptionArgs>>? = null,
    public val nodeToNodeEncryption: Output<DomainNodeToNodeEncryptionArgs>? = null,
    public val snapshotOptions: Output<DomainSnapshotOptionsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcOptions: Output<DomainVpcOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.DomainArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.DomainArgs =
        com.pulumi.aws.elasticsearch.DomainArgs.builder()
            .accessPolicies(accessPolicies?.applyValue({ args0 -> args0 }))
            .advancedOptions(
                advancedOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .advancedSecurityOptions(
                advancedSecurityOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoTuneOptions(autoTuneOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterConfig(clusterConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cognitoOptions(cognitoOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainEndpointOptions(
                domainEndpointOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .ebsOptions(ebsOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticsearchVersion(elasticsearchVersion?.applyValue({ args0 -> args0 }))
            .encryptAtRest(encryptAtRest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logPublishingOptions(
                logPublishingOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nodeToNodeEncryption(
                nodeToNodeEncryption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .snapshotOptions(snapshotOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcOptions(vpcOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var accessPolicies: Output<String>? = null

    private var advancedOptions: Output<Map<String, String>>? = null

    private var advancedSecurityOptions: Output<DomainAdvancedSecurityOptionsArgs>? = null

    private var autoTuneOptions: Output<DomainAutoTuneOptionsArgs>? = null

    private var clusterConfig: Output<DomainClusterConfigArgs>? = null

    private var cognitoOptions: Output<DomainCognitoOptionsArgs>? = null

    private var domainEndpointOptions: Output<DomainDomainEndpointOptionsArgs>? = null

    private var domainName: Output<String>? = null

    private var ebsOptions: Output<DomainEbsOptionsArgs>? = null

    private var elasticsearchVersion: Output<String>? = null

    private var encryptAtRest: Output<DomainEncryptAtRestArgs>? = null

    private var logPublishingOptions: Output<List<DomainLogPublishingOptionArgs>>? = null

    private var nodeToNodeEncryption: Output<DomainNodeToNodeEncryptionArgs>? = null

    private var snapshotOptions: Output<DomainSnapshotOptionsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcOptions: Output<DomainVpcOptionsArgs>? = null

    /**
     * @param value IAM policy document specifying the access policies for the domain.
     */
    @JvmName("ejppfqhhegahltyk")
    public suspend fun accessPolicies(`value`: Output<String>) {
        this.accessPolicies = value
    }

    /**
     * @param value Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your Elasticsearch domain on every apply.
     */
    @JvmName("itgqagaxwaqupmrm")
    public suspend fun advancedOptions(`value`: Output<Map<String, String>>) {
        this.advancedOptions = value
    }

    /**
     * @param value Configuration block for [fine-grained access control](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/fgac.html). Detailed below.
     */
    @JvmName("mjoahugfnlwhrqrl")
    public suspend fun advancedSecurityOptions(`value`: Output<DomainAdvancedSecurityOptionsArgs>) {
        this.advancedSecurityOptions = value
    }

    /**
     * @param value Configuration block for the Auto-Tune options of the domain. Detailed below.
     */
    @JvmName("loeossvyhuoontnc")
    public suspend fun autoTuneOptions(`value`: Output<DomainAutoTuneOptionsArgs>) {
        this.autoTuneOptions = value
    }

    /**
     * @param value Configuration block for the cluster of the domain. Detailed below.
     */
    @JvmName("tswawfusndwpwcpd")
    public suspend fun clusterConfig(`value`: Output<DomainClusterConfigArgs>) {
        this.clusterConfig = value
    }

    /**
     * @param value Configuration block for authenticating Kibana with Cognito. Detailed below.
     */
    @JvmName("nuwfsjkhovdetixp")
    public suspend fun cognitoOptions(`value`: Output<DomainCognitoOptionsArgs>) {
        this.cognitoOptions = value
    }

    /**
     * @param value Configuration block for domain endpoint HTTP(S) related options. Detailed below.
     */
    @JvmName("yifrjgucgjkenspq")
    public suspend fun domainEndpointOptions(`value`: Output<DomainDomainEndpointOptionsArgs>) {
        this.domainEndpointOptions = value
    }

    /**
     * @param value Name of the domain.
     * The following arguments are optional:
     */
    @JvmName("yilpornmgrtmelkv")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/elasticsearch-service/pricing/). Detailed below.
     */
    @JvmName("bsyjmulgvlfaiiqh")
    public suspend fun ebsOptions(`value`: Output<DomainEbsOptionsArgs>) {
        this.ebsOptions = value
    }

    /**
     * @param value Version of Elasticsearch to deploy. Defaults to `1.5`.
     */
    @JvmName("qfsvxfedfivxcdgo")
    public suspend fun elasticsearchVersion(`value`: Output<String>) {
        this.elasticsearchVersion = value
    }

    /**
     * @param value Configuration block for encrypt at rest options. Only available for [certain instance types](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html). Detailed below.
     */
    @JvmName("eejwpevmrsnmhtxy")
    public suspend fun encryptAtRest(`value`: Output<DomainEncryptAtRestArgs>) {
        this.encryptAtRest = value
    }

    /**
     * @param value Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("wpyvrqwqtpwhnadd")
    public suspend fun logPublishingOptions(`value`: Output<List<DomainLogPublishingOptionArgs>>) {
        this.logPublishingOptions = value
    }

    @JvmName("eghstjgdhfarpket")
    public suspend fun logPublishingOptions(vararg values: Output<DomainLogPublishingOptionArgs>) {
        this.logPublishingOptions = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("xkjoyrtggemtluhr")
    public suspend fun logPublishingOptions(values: List<Output<DomainLogPublishingOptionArgs>>) {
        this.logPublishingOptions = Output.all(values)
    }

    /**
     * @param value Configuration block for node-to-node encryption options. Detailed below.
     */
    @JvmName("wbouvkkuncsaucjg")
    public suspend fun nodeToNodeEncryption(`value`: Output<DomainNodeToNodeEncryptionArgs>) {
        this.nodeToNodeEncryption = value
    }

    /**
     * @param value Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running Elasticsearch 5.3 and later, Amazon ES takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions of Elasticsearch, Amazon ES takes daily automated snapshots.
     */
    @JvmName("fvfovfjapxofjbfs")
    public suspend fun snapshotOptions(`value`: Output<DomainSnapshotOptionsArgs>) {
        this.snapshotOptions = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ordupegwikvcbtlu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-vpc-limitations)). Detailed below.
     */
    @JvmName("rxtoharvpxfbgjmr")
    public suspend fun vpcOptions(`value`: Output<DomainVpcOptionsArgs>) {
        this.vpcOptions = value
    }

    /**
     * @param value IAM policy document specifying the access policies for the domain.
     */
    @JvmName("mnbidundxkbxukak")
    public suspend fun accessPolicies(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your Elasticsearch domain on every apply.
     */
    @JvmName("kshafwmcalpoefgx")
    public suspend fun advancedOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedOptions = mapped
    }

    /**
     * @param values Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your Elasticsearch domain on every apply.
     */
    @JvmName("fbqheedobljxffjg")
    public fun advancedOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedOptions = mapped
    }

    /**
     * @param value Configuration block for [fine-grained access control](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/fgac.html). Detailed below.
     */
    @JvmName("vsctwaxhdvnftkdx")
    public suspend fun advancedSecurityOptions(`value`: DomainAdvancedSecurityOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedSecurityOptions = mapped
    }

    /**
     * @param argument Configuration block for [fine-grained access control](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/fgac.html). Detailed below.
     */
    @JvmName("kfrmqoppqnwuxpps")
    public suspend
    fun advancedSecurityOptions(argument: suspend DomainAdvancedSecurityOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainAdvancedSecurityOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.advancedSecurityOptions = mapped
    }

    /**
     * @param value Configuration block for the Auto-Tune options of the domain. Detailed below.
     */
    @JvmName("enklpdqjyspvxhrk")
    public suspend fun autoTuneOptions(`value`: DomainAutoTuneOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoTuneOptions = mapped
    }

    /**
     * @param argument Configuration block for the Auto-Tune options of the domain. Detailed below.
     */
    @JvmName("daynynvrukqrqpab")
    public suspend
    fun autoTuneOptions(argument: suspend DomainAutoTuneOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainAutoTuneOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoTuneOptions = mapped
    }

    /**
     * @param value Configuration block for the cluster of the domain. Detailed below.
     */
    @JvmName("wlcadiporweijrve")
    public suspend fun clusterConfig(`value`: DomainClusterConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterConfig = mapped
    }

    /**
     * @param argument Configuration block for the cluster of the domain. Detailed below.
     */
    @JvmName("iivcxaidwnbbqpby")
    public suspend fun clusterConfig(argument: suspend DomainClusterConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainClusterConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clusterConfig = mapped
    }

    /**
     * @param value Configuration block for authenticating Kibana with Cognito. Detailed below.
     */
    @JvmName("yqnntwjtpwmgcarh")
    public suspend fun cognitoOptions(`value`: DomainCognitoOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoOptions = mapped
    }

    /**
     * @param argument Configuration block for authenticating Kibana with Cognito. Detailed below.
     */
    @JvmName("exhdjljsthlvsquu")
    public suspend fun cognitoOptions(argument: suspend DomainCognitoOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainCognitoOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cognitoOptions = mapped
    }

    /**
     * @param value Configuration block for domain endpoint HTTP(S) related options. Detailed below.
     */
    @JvmName("ctmgvqtdjsmixovs")
    public suspend fun domainEndpointOptions(`value`: DomainDomainEndpointOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainEndpointOptions = mapped
    }

    /**
     * @param argument Configuration block for domain endpoint HTTP(S) related options. Detailed below.
     */
    @JvmName("vblqjdfpxwqnvotk")
    public suspend
    fun domainEndpointOptions(argument: suspend DomainDomainEndpointOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDomainEndpointOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainEndpointOptions = mapped
    }

    /**
     * @param value Name of the domain.
     * The following arguments are optional:
     */
    @JvmName("vjrosfvfvrfprfxy")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/elasticsearch-service/pricing/). Detailed below.
     */
    @JvmName("jjplpildggnmmsqq")
    public suspend fun ebsOptions(`value`: DomainEbsOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptions = mapped
    }

    /**
     * @param argument Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/elasticsearch-service/pricing/). Detailed below.
     */
    @JvmName("uuskairoabcnkybk")
    public suspend fun ebsOptions(argument: suspend DomainEbsOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainEbsOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ebsOptions = mapped
    }

    /**
     * @param value Version of Elasticsearch to deploy. Defaults to `1.5`.
     */
    @JvmName("uphivfrcryxtfblb")
    public suspend fun elasticsearchVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchVersion = mapped
    }

    /**
     * @param value Configuration block for encrypt at rest options. Only available for [certain instance types](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html). Detailed below.
     */
    @JvmName("ccthijjidvpcqfst")
    public suspend fun encryptAtRest(`value`: DomainEncryptAtRestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptAtRest = mapped
    }

    /**
     * @param argument Configuration block for encrypt at rest options. Only available for [certain instance types](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/aes-supported-instance-types.html). Detailed below.
     */
    @JvmName("ssoopsmxlmafkvdm")
    public suspend fun encryptAtRest(argument: suspend DomainEncryptAtRestArgsBuilder.() -> Unit) {
        val toBeMapped = DomainEncryptAtRestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptAtRest = mapped
    }

    /**
     * @param value Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("ghtxxxoqybbikjxl")
    public suspend fun logPublishingOptions(`value`: List<DomainLogPublishingOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logPublishingOptions = mapped
    }

    /**
     * @param argument Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("xpfwdrmihthqaibm")
    public suspend
    fun logPublishingOptions(argument: List<suspend DomainLogPublishingOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainLogPublishingOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logPublishingOptions = mapped
    }

    /**
     * @param argument Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("gragwfiqbtlbdakv")
    public suspend fun logPublishingOptions(
        vararg
        argument: suspend DomainLogPublishingOptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DomainLogPublishingOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logPublishingOptions = mapped
    }

    /**
     * @param argument Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("btxkfnsbksjadblw")
    public suspend
    fun logPublishingOptions(argument: suspend DomainLogPublishingOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainLogPublishingOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logPublishingOptions = mapped
    }

    /**
     * @param values Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
     */
    @JvmName("ckccvdhguuomkhco")
    public suspend fun logPublishingOptions(vararg values: DomainLogPublishingOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logPublishingOptions = mapped
    }

    /**
     * @param value Configuration block for node-to-node encryption options. Detailed below.
     */
    @JvmName("yelcpayvlcfygket")
    public suspend fun nodeToNodeEncryption(`value`: DomainNodeToNodeEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeToNodeEncryption = mapped
    }

    /**
     * @param argument Configuration block for node-to-node encryption options. Detailed below.
     */
    @JvmName("fptvjvknhygesqri")
    public suspend
    fun nodeToNodeEncryption(argument: suspend DomainNodeToNodeEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNodeToNodeEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeToNodeEncryption = mapped
    }

    /**
     * @param value Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running Elasticsearch 5.3 and later, Amazon ES takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions of Elasticsearch, Amazon ES takes daily automated snapshots.
     */
    @JvmName("honmuyyuvjqkfbod")
    public suspend fun snapshotOptions(`value`: DomainSnapshotOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotOptions = mapped
    }

    /**
     * @param argument Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running Elasticsearch 5.3 and later, Amazon ES takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions of Elasticsearch, Amazon ES takes daily automated snapshots.
     */
    @JvmName("keocttdqruhbigon")
    public suspend
    fun snapshotOptions(argument: suspend DomainSnapshotOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainSnapshotOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapshotOptions = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qrawuxkduahyejrn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ygvmkqakyngpeagd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-vpc-limitations)). Detailed below.
     */
    @JvmName("femxhoankfxkmumw")
    public suspend fun vpcOptions(`value`: DomainVpcOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOptions = mapped
    }

    /**
     * @param argument Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-vpc-limitations)). Detailed below.
     */
    @JvmName("mfyoflmeeasikfnl")
    public suspend fun vpcOptions(argument: suspend DomainVpcOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainVpcOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcOptions = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        accessPolicies = accessPolicies,
        advancedOptions = advancedOptions,
        advancedSecurityOptions = advancedSecurityOptions,
        autoTuneOptions = autoTuneOptions,
        clusterConfig = clusterConfig,
        cognitoOptions = cognitoOptions,
        domainEndpointOptions = domainEndpointOptions,
        domainName = domainName,
        ebsOptions = ebsOptions,
        elasticsearchVersion = elasticsearchVersion,
        encryptAtRest = encryptAtRest,
        logPublishingOptions = logPublishingOptions,
        nodeToNodeEncryption = nodeToNodeEncryption,
        snapshotOptions = snapshotOptions,
        tags = tags,
        vpcOptions = vpcOptions,
    )
}
