@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainPolicy].
 */
@PulumiTagMarker
public class DomainPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainPolicyArgs = DomainPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainPolicyArgsBuilder.() -> Unit) {
        val builder = DomainPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainPolicy {
        val builtJavaResource = com.pulumi.aws.elasticsearch.DomainPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainPolicy(builtJavaResource)
    }
}

/**
 * Allows setting policy to an Elasticsearch domain while referencing domain attributes (e.g., ARN)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.DomainPolicy;
 * import com.pulumi.aws.elasticsearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .elasticsearchVersion("2.3")
 *             .build());
 *         var main = new DomainPolicy("main", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(example.arn().applyValue(arn -> """
 * {
 *     "Version": "2012-10-17",
 *     "Statement": [
 *         {
 *             "Action": "es:*",
 *             "Principal": "*",
 *             "Effect": "Allow",
 *             "Condition": {
 *                 "IpAddress": {"aws:SourceIp": "127.0.0.1/32"}
 *             },
 *             "Resource": "%s/*"
 *         }
 *     ]
 * }
 * ", arn)))
 *             .build());
 *     }
 * }
 * ```
 * */
 */
public class DomainPolicy internal constructor(
    override val javaResource: com.pulumi.aws.elasticsearch.DomainPolicy,
) : KotlinCustomResource(javaResource, DomainPolicyMapper) {
    /**
     * IAM policy document specifying the access policies for the domain
     */
    public val accessPolicies: Output<String>
        get() = javaResource.accessPolicies().applyValue({ args0 -> args0 })

    /**
     * Name of the domain.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })
}

public object DomainPolicyMapper : ResourceMapper<DomainPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticsearch.DomainPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DomainPolicy = DomainPolicy(
        javaResource as
            com.pulumi.aws.elasticsearch.DomainPolicy,
    )
}

/**
 * @see [DomainPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainPolicy].
 */
public suspend fun domainPolicy(
    name: String,
    block: suspend DomainPolicyResourceBuilder.() -> Unit,
): DomainPolicy {
    val builder = DomainPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainPolicy(name: String): DomainPolicy {
    val builder = DomainPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
