@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin

import com.pulumi.aws.elasticsearch.DomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows setting policy to an Elasticsearch domain while referencing domain attributes (e.g., ARN)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.DomainPolicy;
 * import com.pulumi.aws.elasticsearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .elasticsearchVersion("2.3")
 *             .build());
 *         var main = new DomainPolicy("main", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(example.arn().applyValue(arn -> """
 * {
 *     "Version": "2012-10-17",
 *     "Statement": [
 *         {
 *             "Action": "es:*",
 *             "Principal": "*",
 *             "Effect": "Allow",
 *             "Condition": {
 *                 "IpAddress": {"aws:SourceIp": "127.0.0.1/32"}
 *             },
 *             "Resource": "%s/*"
 *         }
 *     ]
 * }
 * ", arn)))
 *             .build());
 *     }
 * }
 * ```
 * @property accessPolicies IAM policy document specifying the access policies for the domain
 * @property domainName Name of the domain.
 * */
 */
public data class DomainPolicyArgs(
    public val accessPolicies: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.DomainPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.DomainPolicyArgs =
        com.pulumi.aws.elasticsearch.DomainPolicyArgs.builder()
            .accessPolicies(accessPolicies?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainPolicyArgs].
 */
@PulumiTagMarker
public class DomainPolicyArgsBuilder internal constructor() {
    private var accessPolicies: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("qyjvvlraaarhnone")
    public suspend fun accessPolicies(`value`: Output<String>) {
        this.accessPolicies = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("ciaqmmfxgmlhptqv")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("pthluckxqlkkvplw")
    public suspend fun accessPolicies(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("tymfugkamaviilrw")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainPolicyArgs = DomainPolicyArgs(
        accessPolicies = accessPolicies,
        domainName = domainName,
    )
}
