@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin

import com.pulumi.aws.elasticsearch.VpcEndpointArgs.builder
import com.pulumi.aws.elasticsearch.kotlin.inputs.VpcEndpointVpcOptionsArgs
import com.pulumi.aws.elasticsearch.kotlin.inputs.VpcEndpointVpcOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an [AWS Elasticsearch VPC Endpoint](https://docs.aws.amazon.com/elasticsearch-service/latest/APIReference/API_CreateVpcEndpoint.html). Creates an Amazon elasticsearch Service-managed VPC endpoint.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.VpcEndpoint;
 * import com.pulumi.aws.elasticsearch.VpcEndpointArgs;
 * import com.pulumi.aws.elasticsearch.inputs.VpcEndpointVpcOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new VpcEndpoint("foo", VpcEndpointArgs.builder()
 *             .domainArn(aws_elasticsearch_domain.domain_1().arn())
 *             .vpcOptions(VpcEndpointVpcOptionsArgs.builder()
 *                 .securityGroupIds(
 *                     aws_security_group.test().id(),
 *                     aws_security_group.test2().id())
 *                 .subnetIds(
 *                     aws_subnet.test().id(),
 *                     aws_subnet.test2().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import elasticsearch VPC endpoint connections using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticsearch/vpcEndpoint:VpcEndpoint example endpoint-id
 * ```
 * @property domainArn Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
 * @property vpcOptions Options to specify the subnets and security groups for the endpoint.
 */
public data class VpcEndpointArgs(
    public val domainArn: Output<String>? = null,
    public val vpcOptions: Output<VpcEndpointVpcOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.VpcEndpointArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.VpcEndpointArgs =
        com.pulumi.aws.elasticsearch.VpcEndpointArgs.builder()
            .domainArn(domainArn?.applyValue({ args0 -> args0 }))
            .vpcOptions(vpcOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VpcEndpointArgs].
 */
@PulumiTagMarker
public class VpcEndpointArgsBuilder internal constructor() {
    private var domainArn: Output<String>? = null

    private var vpcOptions: Output<VpcEndpointVpcOptionsArgs>? = null

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
     */
    @JvmName("wouhksqycbsupucb")
    public suspend fun domainArn(`value`: Output<String>) {
        this.domainArn = value
    }

    /**
     * @param value Options to specify the subnets and security groups for the endpoint.
     */
    @JvmName("yniwscasjqsypepk")
    public suspend fun vpcOptions(`value`: Output<VpcEndpointVpcOptionsArgs>) {
        this.vpcOptions = value
    }

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
     */
    @JvmName("gsouvcplkenybqfi")
    public suspend fun domainArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainArn = mapped
    }

    /**
     * @param value Options to specify the subnets and security groups for the endpoint.
     */
    @JvmName("typqudcbnoeqaqnb")
    public suspend fun vpcOptions(`value`: VpcEndpointVpcOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOptions = mapped
    }

    /**
     * @param argument Options to specify the subnets and security groups for the endpoint.
     */
    @JvmName("dpusrdcpntjcskln")
    public suspend fun vpcOptions(argument: suspend VpcEndpointVpcOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcEndpointVpcOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcOptions = mapped
    }

    internal fun build(): VpcEndpointArgs = VpcEndpointArgs(
        domainArn = domainArn,
        vpcOptions = vpcOptions,
    )
}
