@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether advanced security is enabled.
 * @property internalUserDatabaseEnabled Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
 * @property masterUserOptions Configuration block for the main user. Detailed below.
 */
public data class DomainAdvancedSecurityOptionsArgs(
    public val enabled: Output<Boolean>,
    public val internalUserDatabaseEnabled: Output<Boolean>? = null,
    public val masterUserOptions: Output<DomainAdvancedSecurityOptionsMasterUserOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .internalUserDatabaseEnabled(internalUserDatabaseEnabled?.applyValue({ args0 -> args0 }))
            .masterUserOptions(
                masterUserOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainAdvancedSecurityOptionsArgs].
 */
@PulumiTagMarker
public class DomainAdvancedSecurityOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var internalUserDatabaseEnabled: Output<Boolean>? = null

    private var masterUserOptions: Output<DomainAdvancedSecurityOptionsMasterUserOptionsArgs>? = null

    /**
     * @param value Whether advanced security is enabled.
     */
    @JvmName("kfkrecrpoahgbmhb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
     */
    @JvmName("kuyjhmbcslxwcqdl")
    public suspend fun internalUserDatabaseEnabled(`value`: Output<Boolean>) {
        this.internalUserDatabaseEnabled = value
    }

    /**
     * @param value Configuration block for the main user. Detailed below.
     */
    @JvmName("xdwmkdhkontcsefo")
    public suspend
    fun masterUserOptions(`value`: Output<DomainAdvancedSecurityOptionsMasterUserOptionsArgs>) {
        this.masterUserOptions = value
    }

    /**
     * @param value Whether advanced security is enabled.
     */
    @JvmName("qacjfhyahetcfawq")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
     */
    @JvmName("jcpaidsiedbpxpgk")
    public suspend fun internalUserDatabaseEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalUserDatabaseEnabled = mapped
    }

    /**
     * @param value Configuration block for the main user. Detailed below.
     */
    @JvmName("wrjanefpvqkchaeo")
    public suspend
    fun masterUserOptions(`value`: DomainAdvancedSecurityOptionsMasterUserOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUserOptions = mapped
    }

    /**
     * @param argument Configuration block for the main user. Detailed below.
     */
    @JvmName("sxqarkoaflujntjg")
    public suspend
    fun masterUserOptions(argument: suspend DomainAdvancedSecurityOptionsMasterUserOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainAdvancedSecurityOptionsMasterUserOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.masterUserOptions = mapped
    }

    internal fun build(): DomainAdvancedSecurityOptionsArgs = DomainAdvancedSecurityOptionsArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        internalUserDatabaseEnabled = internalUserDatabaseEnabled,
        masterUserOptions = masterUserOptions,
    )
}
