@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ebsEnabled Whether EBS volumes are attached to data nodes in the domain.
 * @property iops Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
 * @property throughput Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
 * @property volumeSize Size of EBS volumes attached to data nodes (in GiB).
 * @property volumeType Type of EBS volumes attached to data nodes.
 */
public data class DomainEbsOptionsArgs(
    public val ebsEnabled: Output<Boolean>,
    public val iops: Output<Int>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs.builder()
            .ebsEnabled(ebsEnabled.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainEbsOptionsArgs].
 */
@PulumiTagMarker
public class DomainEbsOptionsArgsBuilder internal constructor() {
    private var ebsEnabled: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var throughput: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Whether EBS volumes are attached to data nodes in the domain.
     */
    @JvmName("jslyoyqvwoaxjjce")
    public suspend fun ebsEnabled(`value`: Output<Boolean>) {
        this.ebsEnabled = value
    }

    /**
     * @param value Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
     */
    @JvmName("agqicyjijosnkjkt")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
     */
    @JvmName("pbwigbaeqyrxwkcr")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value Size of EBS volumes attached to data nodes (in GiB).
     */
    @JvmName("wpoxkvebvmtbcesm")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value Type of EBS volumes attached to data nodes.
     */
    @JvmName("gdgbhwdkpfnicokp")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Whether EBS volumes are attached to data nodes in the domain.
     */
    @JvmName("xygvdwfuetqeagph")
    public suspend fun ebsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsEnabled = mapped
    }

    /**
     * @param value Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
     */
    @JvmName("fdxarvvtarvbwhjr")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
     */
    @JvmName("ubboiuwrgmypqife")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value Size of EBS volumes attached to data nodes (in GiB).
     */
    @JvmName("ohvvwffqhfyhncnf")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value Type of EBS volumes attached to data nodes.
     */
    @JvmName("jgmoptbtwbfijvja")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): DomainEbsOptionsArgs = DomainEbsOptionsArgs(
        ebsEnabled = ebsEnabled ?: throw PulumiNullFieldException("ebsEnabled"),
        iops = iops,
        throughput = throughput,
        volumeSize = volumeSize,
        volumeType = volumeType,
    )
}
