@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Whether advanced security is enabled.
 * @property internalUserDatabaseEnabled Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
 * @property masterUserOptions Configuration block for the main user. Detailed below.
 */
public data class DomainAdvancedSecurityOptions(
    public val enabled: Boolean,
    public val internalUserDatabaseEnabled: Boolean? = null,
    public val masterUserOptions: DomainAdvancedSecurityOptionsMasterUserOptions? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainAdvancedSecurityOptions):
            DomainAdvancedSecurityOptions = DomainAdvancedSecurityOptions(
            enabled = javaType.enabled(),
            internalUserDatabaseEnabled = javaType.internalUserDatabaseEnabled().map({ args0 ->
                args0
            }).orElse(null),
            masterUserOptions = javaType.masterUserOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.DomainAdvancedSecurityOptionsMasterUserOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
