@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cronExpressionForRecurrence A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
 * @property duration Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
 * @property startAt Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 */
public data class DomainAutoTuneOptionsMaintenanceSchedule(
    public val cronExpressionForRecurrence: String,
    public val duration: DomainAutoTuneOptionsMaintenanceScheduleDuration,
    public val startAt: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainAutoTuneOptionsMaintenanceSchedule):
            DomainAutoTuneOptionsMaintenanceSchedule = DomainAutoTuneOptionsMaintenanceSchedule(
            cronExpressionForRecurrence = javaType.cronExpressionForRecurrence(),
            duration = javaType.duration().let({ args0 ->
                com.pulumi.aws.elasticsearch.kotlin.outputs.DomainAutoTuneOptionsMaintenanceScheduleDuration.Companion.toKotlin(args0)
            }),
            startAt = javaType.startAt(),
        )
    }
}
