@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `elasticsearch_version` of `6.0` or greater.
 */
public data class DomainNodeToNodeEncryption(
    public val enabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainNodeToNodeEncryption):
            DomainNodeToNodeEncryption = DomainNodeToNodeEncryption(
            enabled = javaType.enabled(),
        )
    }
}
