@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones
 * @property securityGroupIds List of VPC Security Group IDs to be applied to the Elasticsearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
 * @property subnetIds List of VPC Subnet IDs for the Elasticsearch domain endpoints to be created in.
 * @property vpcId
 */
public data class DomainVpcOptions(
    public val availabilityZones: List<String>? = null,
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainVpcOptions):
            DomainVpcOptions = DomainVpcOptions(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
