@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether node to node encryption is enabled.
 * @property identityPoolId The Cognito Identity pool used by the domain.
 * @property roleArn The IAM Role with the AmazonESCognitoAccess policy attached.
 * @property userPoolId The Cognito User pool used by the domain.
 */
public data class GetDomainCognitoOption(
    public val enabled: Boolean,
    public val identityPoolId: String,
    public val roleArn: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.GetDomainCognitoOption):
            GetDomainCognitoOption = GetDomainCognitoOption(
            enabled = javaType.enabled(),
            identityPoolId = javaType.identityPoolId(),
            roleArn = javaType.roleArn(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
