@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin

import com.pulumi.aws.elastictranscoder.PipelineArgs.builder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineContentConfigArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineContentConfigArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineContentConfigPermissionArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineContentConfigPermissionArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineNotificationsArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineNotificationsArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineThumbnailConfigArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineThumbnailConfigArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineThumbnailConfigPermissionArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PipelineThumbnailConfigPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Transcoder pipeline resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elastictranscoder.Pipeline;
 * import com.pulumi.aws.elastictranscoder.PipelineArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Pipeline("bar", PipelineArgs.builder()
 *             .inputBucket(aws_s3_bucket.input_bucket().id())
 *             .role(aws_iam_role.test_role().arn())
 *             .contentConfig(PipelineContentConfigArgs.builder()
 *                 .bucket(aws_s3_bucket.content_bucket().id())
 *                 .storageClass("Standard")
 *                 .build())
 *             .thumbnailConfig(PipelineThumbnailConfigArgs.builder()
 *                 .bucket(aws_s3_bucket.thumb_bucket().id())
 *                 .storageClass("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elastic Transcoder pipelines using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:elastictranscoder/pipeline:Pipeline basic_pipeline 1407981661351-cttk8b
 * ```
 * @property awsKmsKeyArn The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
 * @property contentConfig The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
 * @property contentConfigPermissions The permissions for the `content_config` object. (documented below)
 * @property inputBucket The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
 * @property name The name of the pipeline. Maximum 40 characters
 * @property notifications The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
 * @property outputBucket The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
 * @property role The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
 * @property thumbnailConfig The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
 * @property thumbnailConfigPermissions The permissions for the `thumbnail_config` object. (documented below)
 * The `content_config` object specifies information about the Amazon S3 bucket in
 * which you want Elastic Transcoder to save transcoded files and playlists: which
 * bucket to use, and the storage class that you want to assign to the files. If
 * you specify values for `content_config`, you must also specify values for
 * `thumbnail_config`. If you specify values for `content_config` and
 * `thumbnail_config`, omit the `output_bucket` object.
 */
public data class PipelineArgs(
    public val awsKmsKeyArn: Output<String>? = null,
    public val contentConfig: Output<PipelineContentConfigArgs>? = null,
    public val contentConfigPermissions: Output<List<PipelineContentConfigPermissionArgs>>? = null,
    public val inputBucket: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notifications: Output<PipelineNotificationsArgs>? = null,
    public val outputBucket: Output<String>? = null,
    public val role: Output<String>? = null,
    public val thumbnailConfig: Output<PipelineThumbnailConfigArgs>? = null,
    public val thumbnailConfigPermissions: Output<List<PipelineThumbnailConfigPermissionArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.PipelineArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.PipelineArgs =
        com.pulumi.aws.elastictranscoder.PipelineArgs.builder()
            .awsKmsKeyArn(awsKmsKeyArn?.applyValue({ args0 -> args0 }))
            .contentConfig(contentConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contentConfigPermissions(
                contentConfigPermissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputBucket(inputBucket?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notifications(notifications?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputBucket(outputBucket?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .thumbnailConfig(thumbnailConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .thumbnailConfigPermissions(
                thumbnailConfigPermissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var awsKmsKeyArn: Output<String>? = null

    private var contentConfig: Output<PipelineContentConfigArgs>? = null

    private var contentConfigPermissions: Output<List<PipelineContentConfigPermissionArgs>>? = null

    private var inputBucket: Output<String>? = null

    private var name: Output<String>? = null

    private var notifications: Output<PipelineNotificationsArgs>? = null

    private var outputBucket: Output<String>? = null

    private var role: Output<String>? = null

    private var thumbnailConfig: Output<PipelineThumbnailConfigArgs>? = null

    private var thumbnailConfigPermissions: Output<List<PipelineThumbnailConfigPermissionArgs>>? =
        null

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     */
    @JvmName("lckklcotwqptkakc")
    public suspend fun awsKmsKeyArn(`value`: Output<String>) {
        this.awsKmsKeyArn = value
    }

    /**
     * @param value The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
     */
    @JvmName("snlfbglsqlwundpd")
    public suspend fun contentConfig(`value`: Output<PipelineContentConfigArgs>) {
        this.contentConfig = value
    }

    /**
     * @param value The permissions for the `content_config` object. (documented below)
     */
    @JvmName("oghoedrkoolyyite")
    public suspend
    fun contentConfigPermissions(`value`: Output<List<PipelineContentConfigPermissionArgs>>) {
        this.contentConfigPermissions = value
    }

    @JvmName("qjmqktmeretojqtv")
    public suspend fun contentConfigPermissions(
        vararg
        values: Output<PipelineContentConfigPermissionArgs>,
    ) {
        this.contentConfigPermissions = Output.all(values.asList())
    }

    /**
     * @param values The permissions for the `content_config` object. (documented below)
     */
    @JvmName("aafrnlgmqtpwsdqt")
    public suspend
    fun contentConfigPermissions(values: List<Output<PipelineContentConfigPermissionArgs>>) {
        this.contentConfigPermissions = Output.all(values)
    }

    /**
     * @param value The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
     */
    @JvmName("gdtlboxxapgwrtkl")
    public suspend fun inputBucket(`value`: Output<String>) {
        this.inputBucket = value
    }

    /**
     * @param value The name of the pipeline. Maximum 40 characters
     */
    @JvmName("xjcdcnugadtfhvtw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
     */
    @JvmName("tixbgukvhslkhnar")
    public suspend fun notifications(`value`: Output<PipelineNotificationsArgs>) {
        this.notifications = value
    }

    /**
     * @param value The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
     */
    @JvmName("lxhychmpdfjyejic")
    public suspend fun outputBucket(`value`: Output<String>) {
        this.outputBucket = value
    }

    /**
     * @param value The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
     */
    @JvmName("xcrsssqqatphahwf")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
     */
    @JvmName("nvuhtfovcgrqpofs")
    public suspend fun thumbnailConfig(`value`: Output<PipelineThumbnailConfigArgs>) {
        this.thumbnailConfig = value
    }

    /**
     * @param value The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("xtuxbhfmplxevhgr")
    public suspend
    fun thumbnailConfigPermissions(`value`: Output<List<PipelineThumbnailConfigPermissionArgs>>) {
        this.thumbnailConfigPermissions = value
    }

    @JvmName("seopglgbylafvmfx")
    public suspend fun thumbnailConfigPermissions(
        vararg
        values: Output<PipelineThumbnailConfigPermissionArgs>,
    ) {
        this.thumbnailConfigPermissions = Output.all(values.asList())
    }

    /**
     * @param values The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("hjwfluykyvgkpaeq")
    public suspend
    fun thumbnailConfigPermissions(values: List<Output<PipelineThumbnailConfigPermissionArgs>>) {
        this.thumbnailConfigPermissions = Output.all(values)
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     */
    @JvmName("caulegtpieoqburq")
    public suspend fun awsKmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsKmsKeyArn = mapped
    }

    /**
     * @param value The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
     */
    @JvmName("ukpcwhllphuidpkw")
    public suspend fun contentConfig(`value`: PipelineContentConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentConfig = mapped
    }

    /**
     * @param argument The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
     */
    @JvmName("fykgnxjctifgsyst")
    public suspend fun contentConfig(argument: suspend PipelineContentConfigArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineContentConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentConfig = mapped
    }

    /**
     * @param value The permissions for the `content_config` object. (documented below)
     */
    @JvmName("bdwqlcpdvovbvrhj")
    public suspend fun contentConfigPermissions(`value`: List<PipelineContentConfigPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentConfigPermissions = mapped
    }

    /**
     * @param argument The permissions for the `content_config` object. (documented below)
     */
    @JvmName("shekueqrhklbrslm")
    public suspend
    fun contentConfigPermissions(argument: List<suspend PipelineContentConfigPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineContentConfigPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.contentConfigPermissions = mapped
    }

    /**
     * @param argument The permissions for the `content_config` object. (documented below)
     */
    @JvmName("ntfnjowawlgwdvxs")
    public suspend fun contentConfigPermissions(
        vararg
        argument: suspend PipelineContentConfigPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineContentConfigPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.contentConfigPermissions = mapped
    }

    /**
     * @param argument The permissions for the `content_config` object. (documented below)
     */
    @JvmName("ccgldugrnxyecftp")
    public suspend
    fun contentConfigPermissions(argument: suspend PipelineContentConfigPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineContentConfigPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.contentConfigPermissions = mapped
    }

    /**
     * @param values The permissions for the `content_config` object. (documented below)
     */
    @JvmName("ewvfbbhhblbuhcps")
    public suspend fun contentConfigPermissions(vararg values: PipelineContentConfigPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentConfigPermissions = mapped
    }

    /**
     * @param value The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
     */
    @JvmName("offdynfmxyjyidee")
    public suspend fun inputBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputBucket = mapped
    }

    /**
     * @param value The name of the pipeline. Maximum 40 characters
     */
    @JvmName("cjwttvkmpfqfdnio")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
     */
    @JvmName("qaicfefgficothxc")
    public suspend fun notifications(`value`: PipelineNotificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param argument The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
     */
    @JvmName("brortmnjmjvlsmql")
    public suspend fun notifications(argument: suspend PipelineNotificationsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineNotificationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param value The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
     */
    @JvmName("afbydaqsqdiexcpy")
    public suspend fun outputBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBucket = mapped
    }

    /**
     * @param value The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
     */
    @JvmName("jgvpfybselkcpsmh")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
     */
    @JvmName("bhafyapvhulwhorf")
    public suspend fun thumbnailConfig(`value`: PipelineThumbnailConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbnailConfig = mapped
    }

    /**
     * @param argument The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
     */
    @JvmName("kagktiogpoxilgxj")
    public suspend
    fun thumbnailConfig(argument: suspend PipelineThumbnailConfigArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineThumbnailConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.thumbnailConfig = mapped
    }

    /**
     * @param value The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("dmnymuoasnrkyxga")
    public suspend
    fun thumbnailConfigPermissions(`value`: List<PipelineThumbnailConfigPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbnailConfigPermissions = mapped
    }

    /**
     * @param argument The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("khctkcfpgnybipxh")
    public suspend
    fun thumbnailConfigPermissions(argument: List<suspend PipelineThumbnailConfigPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineThumbnailConfigPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.thumbnailConfigPermissions = mapped
    }

    /**
     * @param argument The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("mnnxtadsxeiddfdn")
    public suspend fun thumbnailConfigPermissions(
        vararg
        argument: suspend PipelineThumbnailConfigPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineThumbnailConfigPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.thumbnailConfigPermissions = mapped
    }

    /**
     * @param argument The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("ydxmlewnsrbysgjn")
    public suspend
    fun thumbnailConfigPermissions(argument: suspend PipelineThumbnailConfigPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineThumbnailConfigPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.thumbnailConfigPermissions = mapped
    }

    /**
     * @param values The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    @JvmName("bnphpeclfxbtqhqe")
    public suspend fun thumbnailConfigPermissions(
        vararg
        values: PipelineThumbnailConfigPermissionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thumbnailConfigPermissions = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        awsKmsKeyArn = awsKmsKeyArn,
        contentConfig = contentConfig,
        contentConfigPermissions = contentConfigPermissions,
        inputBucket = inputBucket,
        name = name,
        notifications = notifications,
        outputBucket = outputBucket,
        role = role,
        thumbnailConfig = thumbnailConfig,
        thumbnailConfigPermissions = thumbnailConfigPermissions,
    )
}
