@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin

import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudio
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudioCodecOptions
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetThumbnails
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideo
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideoWatermark
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudio.Companion.toKotlin as presetAudioToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudioCodecOptions.Companion.toKotlin as presetAudioCodecOptionsToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetThumbnails.Companion.toKotlin as presetThumbnailsToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideo.Companion.toKotlin as presetVideoToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideoWatermark.Companion.toKotlin as presetVideoWatermarkToKotlin

/**
 * Builder for [Preset].
 */
@PulumiTagMarker
public class PresetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PresetArgs = PresetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PresetArgsBuilder.() -> Unit) {
        val builder = PresetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Preset {
        val builtJavaResource = com.pulumi.aws.elastictranscoder.Preset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Preset(builtJavaResource)
    }
}

/**
 * Provides an Elastic Transcoder preset resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elastictranscoder.Preset;
 * import com.pulumi.aws.elastictranscoder.PresetArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Preset("bar", PresetArgs.builder()
 *             .audio(PresetAudioArgs.builder()
 *                 .audioPackingMode("SingleTrack")
 *                 .bitRate(96)
 *                 .channels(2)
 *                 .codec("AAC")
 *                 .sampleRate(44100)
 *                 .build())
 *             .audioCodecOptions(PresetAudioCodecOptionsArgs.builder()
 *                 .profile("AAC-LC")
 *                 .build())
 *             .container("mp4")
 *             .description("Sample Preset")
 *             .thumbnails(PresetThumbnailsArgs.builder()
 *                 .format("png")
 *                 .interval(120)
 *                 .maxHeight("auto")
 *                 .maxWidth("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .video(PresetVideoArgs.builder()
 *                 .bitRate("1600")
 *                 .codec("H.264")
 *                 .displayAspectRatio("16:9")
 *                 .fixedGop("false")
 *                 .frameRate("auto")
 *                 .keyframesMaxDist(240)
 *                 .maxFrameRate("60")
 *                 .maxHeight("auto")
 *                 .maxWidth("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .videoCodecOptions(Map.ofEntries(
 *                 Map.entry("ColorSpaceConversionMode", "None"),
 *                 Map.entry("InterlacedMode", "Progressive"),
 *                 Map.entry("Level", "2.2"),
 *                 Map.entry("MaxReferenceFrames", 3),
 *                 Map.entry("Profile", "main")
 *             ))
 *             .videoWatermarks(PresetVideoWatermarkArgs.builder()
 *                 .horizontalAlign("Right")
 *                 .horizontalOffset("10px")
 *                 .id("Test")
 *                 .maxHeight("20%")
 *                 .maxWidth("20%")
 *                 .opacity("55.5")
 *                 .sizingPolicy("ShrinkToFit")
 *                 .target("Content")
 *                 .verticalAlign("Bottom")
 *                 .verticalOffset("10px")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elastic Transcoder presets using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:elastictranscoder/preset:Preset basic_preset 1407981661351-cttk8b
 * ```
 *
 */
public class Preset internal constructor(
    override val javaResource: com.pulumi.aws.elastictranscoder.Preset,
) : KotlinCustomResource(javaResource, PresetMapper) {
    /**
     * Amazon Resource Name (ARN) of the Elastic Transcoder Preset.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Audio parameters object (documented below).
     */
    public val audio: Output<PresetAudio>?
        get() = javaResource.audio().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    presetAudioToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Codec options for the audio parameters (documented below)
     */
    public val audioCodecOptions: Output<PresetAudioCodecOptions>
        get() = javaResource.audioCodecOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                presetAudioCodecOptionsToKotlin(args0)
            })
        })

    /**
     * The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    public val container: Output<String>
        get() = javaResource.container().applyValue({ args0 -> args0 })

    /**
     * A description of the preset (maximum 255 characters)
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the preset. (maximum 40 characters)
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Thumbnail parameters object (documented below)
     */
    public val thumbnails: Output<PresetThumbnails>?
        get() = javaResource.thumbnails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    presetThumbnailsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Video parameters object (documented below)
     */
    public val video: Output<PresetVideo>?
        get() = javaResource.video().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    presetVideoToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Codec options for the video parameters
     */
    public val videoCodecOptions: Output<Map<String, String>>?
        get() = javaResource.videoCodecOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Watermark parameters for the video parameters (documented below)
     */
    public val videoWatermarks: Output<List<PresetVideoWatermark>>?
        get() = javaResource.videoWatermarks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        presetVideoWatermarkToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object PresetMapper : ResourceMapper<Preset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elastictranscoder.Preset::class == javaResource::class

    override fun map(javaResource: Resource): Preset = Preset(
        javaResource as
            com.pulumi.aws.elastictranscoder.Preset,
    )
}

/**
 * @see [Preset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Preset].
 */
public suspend fun preset(name: String, block: suspend PresetResourceBuilder.() -> Unit): Preset {
    val builder = PresetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Preset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun preset(name: String): Preset {
    val builder = PresetResourceBuilder()
    builder.name(name)
    return builder.build()
}
