@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin

import com.pulumi.aws.elastictranscoder.PresetArgs.builder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioCodecOptionsArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioCodecOptionsArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetThumbnailsArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetThumbnailsArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoWatermarkArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoWatermarkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Transcoder preset resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elastictranscoder.Preset;
 * import com.pulumi.aws.elastictranscoder.PresetArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Preset("bar", PresetArgs.builder()
 *             .audio(PresetAudioArgs.builder()
 *                 .audioPackingMode("SingleTrack")
 *                 .bitRate(96)
 *                 .channels(2)
 *                 .codec("AAC")
 *                 .sampleRate(44100)
 *                 .build())
 *             .audioCodecOptions(PresetAudioCodecOptionsArgs.builder()
 *                 .profile("AAC-LC")
 *                 .build())
 *             .container("mp4")
 *             .description("Sample Preset")
 *             .thumbnails(PresetThumbnailsArgs.builder()
 *                 .format("png")
 *                 .interval(120)
 *                 .maxHeight("auto")
 *                 .maxWidth("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .video(PresetVideoArgs.builder()
 *                 .bitRate("1600")
 *                 .codec("H.264")
 *                 .displayAspectRatio("16:9")
 *                 .fixedGop("false")
 *                 .frameRate("auto")
 *                 .keyframesMaxDist(240)
 *                 .maxFrameRate("60")
 *                 .maxHeight("auto")
 *                 .maxWidth("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .videoCodecOptions(Map.ofEntries(
 *                 Map.entry("ColorSpaceConversionMode", "None"),
 *                 Map.entry("InterlacedMode", "Progressive"),
 *                 Map.entry("Level", "2.2"),
 *                 Map.entry("MaxReferenceFrames", 3),
 *                 Map.entry("Profile", "main")
 *             ))
 *             .videoWatermarks(PresetVideoWatermarkArgs.builder()
 *                 .horizontalAlign("Right")
 *                 .horizontalOffset("10px")
 *                 .id("Test")
 *                 .maxHeight("20%")
 *                 .maxWidth("20%")
 *                 .opacity("55.5")
 *                 .sizingPolicy("ShrinkToFit")
 *                 .target("Content")
 *                 .verticalAlign("Bottom")
 *                 .verticalOffset("10px")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elastic Transcoder presets using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:elastictranscoder/preset:Preset basic_preset 1407981661351-cttk8b
 * ```
 * @property audio Audio parameters object (documented below).
 * @property audioCodecOptions Codec options for the audio parameters (documented below)
 * @property container The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
 * @property description A description of the preset (maximum 255 characters)
 * @property name The name of the preset. (maximum 40 characters)
 * @property thumbnails Thumbnail parameters object (documented below)
 * @property type
 * @property video Video parameters object (documented below)
 * @property videoCodecOptions Codec options for the video parameters
 * @property videoWatermarks Watermark parameters for the video parameters (documented below)
 */
public data class PresetArgs(
    public val audio: Output<PresetAudioArgs>? = null,
    public val audioCodecOptions: Output<PresetAudioCodecOptionsArgs>? = null,
    public val container: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val thumbnails: Output<PresetThumbnailsArgs>? = null,
    public val type: Output<String>? = null,
    public val video: Output<PresetVideoArgs>? = null,
    public val videoCodecOptions: Output<Map<String, String>>? = null,
    public val videoWatermarks: Output<List<PresetVideoWatermarkArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.PresetArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.PresetArgs =
        com.pulumi.aws.elastictranscoder.PresetArgs.builder()
            .audio(audio?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .audioCodecOptions(audioCodecOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .container(container?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .thumbnails(thumbnails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .video(video?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .videoCodecOptions(
                videoCodecOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .videoWatermarks(
                videoWatermarks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PresetArgs].
 */
@PulumiTagMarker
public class PresetArgsBuilder internal constructor() {
    private var audio: Output<PresetAudioArgs>? = null

    private var audioCodecOptions: Output<PresetAudioCodecOptionsArgs>? = null

    private var container: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var thumbnails: Output<PresetThumbnailsArgs>? = null

    private var type: Output<String>? = null

    private var video: Output<PresetVideoArgs>? = null

    private var videoCodecOptions: Output<Map<String, String>>? = null

    private var videoWatermarks: Output<List<PresetVideoWatermarkArgs>>? = null

    /**
     * @param value Audio parameters object (documented below).
     */
    @JvmName("pbiytivaltbysmlh")
    public suspend fun audio(`value`: Output<PresetAudioArgs>) {
        this.audio = value
    }

    /**
     * @param value Codec options for the audio parameters (documented below)
     */
    @JvmName("pjyauyqyoroasjuv")
    public suspend fun audioCodecOptions(`value`: Output<PresetAudioCodecOptionsArgs>) {
        this.audioCodecOptions = value
    }

    /**
     * @param value The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    @JvmName("xwgfiplwsqytnpfs")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value A description of the preset (maximum 255 characters)
     */
    @JvmName("xndrdnmbdawicpyr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the preset. (maximum 40 characters)
     */
    @JvmName("vglbwcclgokclfhm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Thumbnail parameters object (documented below)
     */
    @JvmName("asdcpjqhehiqyfpx")
    public suspend fun thumbnails(`value`: Output<PresetThumbnailsArgs>) {
        this.thumbnails = value
    }

    /**
     * @param value
     */
    @JvmName("miudfktmfxdvugas")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Video parameters object (documented below)
     */
    @JvmName("ehylcbmdnoiqqynd")
    public suspend fun video(`value`: Output<PresetVideoArgs>) {
        this.video = value
    }

    /**
     * @param value Codec options for the video parameters
     */
    @JvmName("wjklwumpogsqltib")
    public suspend fun videoCodecOptions(`value`: Output<Map<String, String>>) {
        this.videoCodecOptions = value
    }

    /**
     * @param value Watermark parameters for the video parameters (documented below)
     */
    @JvmName("pvxjyiynbtioyicr")
    public suspend fun videoWatermarks(`value`: Output<List<PresetVideoWatermarkArgs>>) {
        this.videoWatermarks = value
    }

    @JvmName("bwhjrlhruwttnxhm")
    public suspend fun videoWatermarks(vararg values: Output<PresetVideoWatermarkArgs>) {
        this.videoWatermarks = Output.all(values.asList())
    }

    /**
     * @param values Watermark parameters for the video parameters (documented below)
     */
    @JvmName("psmxemhvjitbaehj")
    public suspend fun videoWatermarks(values: List<Output<PresetVideoWatermarkArgs>>) {
        this.videoWatermarks = Output.all(values)
    }

    /**
     * @param value Audio parameters object (documented below).
     */
    @JvmName("pgvanwkitwovkhdi")
    public suspend fun audio(`value`: PresetAudioArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audio = mapped
    }

    /**
     * @param argument Audio parameters object (documented below).
     */
    @JvmName("wsywwsoywdmjvhma")
    public suspend fun audio(argument: suspend PresetAudioArgsBuilder.() -> Unit) {
        val toBeMapped = PresetAudioArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.audio = mapped
    }

    /**
     * @param value Codec options for the audio parameters (documented below)
     */
    @JvmName("akwqtxlcunyxfpst")
    public suspend fun audioCodecOptions(`value`: PresetAudioCodecOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioCodecOptions = mapped
    }

    /**
     * @param argument Codec options for the audio parameters (documented below)
     */
    @JvmName("boasaliaegpgbrmy")
    public suspend
    fun audioCodecOptions(argument: suspend PresetAudioCodecOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PresetAudioCodecOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.audioCodecOptions = mapped
    }

    /**
     * @param value The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    @JvmName("pgovmnrindsbdlvw")
    public suspend fun container(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value A description of the preset (maximum 255 characters)
     */
    @JvmName("dvqugmcjogokrcde")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the preset. (maximum 40 characters)
     */
    @JvmName("souteuwbkrgqugdt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Thumbnail parameters object (documented below)
     */
    @JvmName("abntqjgosxshkcbp")
    public suspend fun thumbnails(`value`: PresetThumbnailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbnails = mapped
    }

    /**
     * @param argument Thumbnail parameters object (documented below)
     */
    @JvmName("kicfmempsrfbreli")
    public suspend fun thumbnails(argument: suspend PresetThumbnailsArgsBuilder.() -> Unit) {
        val toBeMapped = PresetThumbnailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.thumbnails = mapped
    }

    /**
     * @param value
     */
    @JvmName("payihyqindfkpnmn")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Video parameters object (documented below)
     */
    @JvmName("xicgldcmuqyjgsbl")
    public suspend fun video(`value`: PresetVideoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.video = mapped
    }

    /**
     * @param argument Video parameters object (documented below)
     */
    @JvmName("rftetbghlpmjxoop")
    public suspend fun video(argument: suspend PresetVideoArgsBuilder.() -> Unit) {
        val toBeMapped = PresetVideoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.video = mapped
    }

    /**
     * @param value Codec options for the video parameters
     */
    @JvmName("wafxvsesxijvmcox")
    public suspend fun videoCodecOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoCodecOptions = mapped
    }

    /**
     * @param values Codec options for the video parameters
     */
    @JvmName("fnhldtnrukwwnmyw")
    public fun videoCodecOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoCodecOptions = mapped
    }

    /**
     * @param value Watermark parameters for the video parameters (documented below)
     */
    @JvmName("asypsfkttqvjfsbt")
    public suspend fun videoWatermarks(`value`: List<PresetVideoWatermarkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoWatermarks = mapped
    }

    /**
     * @param argument Watermark parameters for the video parameters (documented below)
     */
    @JvmName("klyrtliitremupah")
    public suspend
    fun videoWatermarks(argument: List<suspend PresetVideoWatermarkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PresetVideoWatermarkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.videoWatermarks = mapped
    }

    /**
     * @param argument Watermark parameters for the video parameters (documented below)
     */
    @JvmName("ptqaigddhcbksypm")
    public suspend fun videoWatermarks(
        vararg
        argument: suspend PresetVideoWatermarkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PresetVideoWatermarkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.videoWatermarks = mapped
    }

    /**
     * @param argument Watermark parameters for the video parameters (documented below)
     */
    @JvmName("pbgxjaqvkawdgckq")
    public suspend fun videoWatermarks(argument: suspend PresetVideoWatermarkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PresetVideoWatermarkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.videoWatermarks = mapped
    }

    /**
     * @param values Watermark parameters for the video parameters (documented below)
     */
    @JvmName("pjyqrxsuedmmupdk")
    public suspend fun videoWatermarks(vararg values: PresetVideoWatermarkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoWatermarks = mapped
    }

    internal fun build(): PresetArgs = PresetArgs(
        audio = audio,
        audioCodecOptions = audioCodecOptions,
        container = container,
        description = description,
        name = name,
        thumbnails = thumbnails,
        type = type,
        video = video,
        videoCodecOptions = videoCodecOptions,
        videoWatermarks = videoWatermarks,
    )
}
