@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property audioPackingMode The method of organizing audio channels and tracks. Use Audio:Channels to specify the number of channels in your output, and Audio:AudioPackingMode to specify the number of tracks and their relation to the channels. If you do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
 * @property bitRate The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
 * @property channels The number of audio channels in the output file
 * @property codec The audio codec for the output file. Valid values are `AAC`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
 * @property sampleRate The sample rate of the audio stream in the output file, in hertz. Valid values are: `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
 */
public data class PresetAudioArgs(
    public val audioPackingMode: Output<String>? = null,
    public val bitRate: Output<String>? = null,
    public val channels: Output<String>? = null,
    public val codec: Output<String>? = null,
    public val sampleRate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs =
        com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs.builder()
            .audioPackingMode(audioPackingMode?.applyValue({ args0 -> args0 }))
            .bitRate(bitRate?.applyValue({ args0 -> args0 }))
            .channels(channels?.applyValue({ args0 -> args0 }))
            .codec(codec?.applyValue({ args0 -> args0 }))
            .sampleRate(sampleRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PresetAudioArgs].
 */
@PulumiTagMarker
public class PresetAudioArgsBuilder internal constructor() {
    private var audioPackingMode: Output<String>? = null

    private var bitRate: Output<String>? = null

    private var channels: Output<String>? = null

    private var codec: Output<String>? = null

    private var sampleRate: Output<String>? = null

    /**
     * @param value The method of organizing audio channels and tracks. Use Audio:Channels to specify the number of channels in your output, and Audio:AudioPackingMode to specify the number of tracks and their relation to the channels. If you do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
     */
    @JvmName("qowbtrybnkubrvcu")
    public suspend fun audioPackingMode(`value`: Output<String>) {
        this.audioPackingMode = value
    }

    /**
     * @param value The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
     */
    @JvmName("akrhllebgfvkxdmh")
    public suspend fun bitRate(`value`: Output<String>) {
        this.bitRate = value
    }

    /**
     * @param value The number of audio channels in the output file
     */
    @JvmName("uuvtncgqitnejcgo")
    public suspend fun channels(`value`: Output<String>) {
        this.channels = value
    }

    /**
     * @param value The audio codec for the output file. Valid values are `AAC`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
     */
    @JvmName("gxqocmimpfoalhch")
    public suspend fun codec(`value`: Output<String>) {
        this.codec = value
    }

    /**
     * @param value The sample rate of the audio stream in the output file, in hertz. Valid values are: `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
     */
    @JvmName("yukponqlmdcnivah")
    public suspend fun sampleRate(`value`: Output<String>) {
        this.sampleRate = value
    }

    /**
     * @param value The method of organizing audio channels and tracks. Use Audio:Channels to specify the number of channels in your output, and Audio:AudioPackingMode to specify the number of tracks and their relation to the channels. If you do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
     */
    @JvmName("mrxqajnykpfkrumx")
    public suspend fun audioPackingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioPackingMode = mapped
    }

    /**
     * @param value The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
     */
    @JvmName("ikpasfoyklrypryl")
    public suspend fun bitRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitRate = mapped
    }

    /**
     * @param value The number of audio channels in the output file
     */
    @JvmName("ucipygnemoyepior")
    public suspend fun channels(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channels = mapped
    }

    /**
     * @param value The audio codec for the output file. Valid values are `AAC`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
     */
    @JvmName("iexhmlgxjpshjrxh")
    public suspend fun codec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codec = mapped
    }

    /**
     * @param value The sample rate of the audio stream in the output file, in hertz. Valid values are: `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
     */
    @JvmName("ojxcuhgderuyujgn")
    public suspend fun sampleRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleRate = mapped
    }

    internal fun build(): PresetAudioArgs = PresetAudioArgs(
        audioPackingMode = audioPackingMode,
        bitRate = bitRate,
        channels = channels,
        codec = codec,
        sampleRate = sampleRate,
    )
}
