@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
 * @property storageClass The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the files and playlists that it stores in your Amazon S3 bucket.
 */
public data class PipelineContentConfig(
    public val bucket: String? = null,
    public val storageClass: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PipelineContentConfig):
            PipelineContentConfig = PipelineContentConfig(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            storageClass = javaType.storageClass().map({ args0 -> args0 }).orElse(null),
        )
    }
}
