@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accesses The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
 * @property grantee The AWS user or group that you want to have access to transcoded files and playlists.
 * @property granteeType Specify the type of value that appears in the `content_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
 */
public data class PipelineContentConfigPermission(
    public val accesses: List<String>? = null,
    public val grantee: String? = null,
    public val granteeType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PipelineContentConfigPermission):
            PipelineContentConfigPermission = PipelineContentConfigPermission(
            accesses = javaType.accesses().map({ args0 -> args0 }),
            grantee = javaType.grantee().map({ args0 -> args0 }).orElse(null),
            granteeType = javaType.granteeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
