@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bitDepth The bit depth of a sample is how many bits of information are included in the audio samples. Valid values are `16` and `24`. (FLAC/PCM Only)
 * @property bitOrder The order the bits of a PCM sample are stored in. The supported value is LittleEndian. (PCM Only)
 * @property profile If you specified AAC for Audio:Codec, choose the AAC profile for the output file.
 * @property signed Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned). The supported value is Signed. (PCM Only)
 */
public data class PresetAudioCodecOptions(
    public val bitDepth: String? = null,
    public val bitOrder: String? = null,
    public val profile: String? = null,
    public val signed: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PresetAudioCodecOptions):
            PresetAudioCodecOptions = PresetAudioCodecOptions(
            bitDepth = javaType.bitDepth().map({ args0 -> args0 }).orElse(null),
            bitOrder = javaType.bitOrder().map({ args0 -> args0 }).orElse(null),
            profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
            signed = javaType.signed().map({ args0 -> args0 }).orElse(null),
        )
    }
}
