@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aspectRatio The aspect ratio of thumbnails. The following values are valid: auto, 1:1, 4:3, 3:2, 16:9
 * @property format The format of thumbnails, if any. Valid formats are jpg and png.
 * @property interval The approximate number of seconds between thumbnails. The value must be an integer. The actual interval can vary by several seconds from one thumbnail to the next.
 * @property maxHeight The maximum height of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
 * @property maxWidth The maximum width of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
 * @property paddingPolicy When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail MaxWidth and MaxHeight settings.
 * @property resolution The width and height of thumbnail files in pixels, in the format WidthxHeight, where both values are even integers. The values cannot exceed the width and height that you specified in the Video:Resolution object. (To better control resolution and aspect ratio of thumbnails, we recommend that you use the thumbnail values `max_width`, `max_height`, `sizing_policy`, and `padding_policy` instead of `resolution` and `aspect_ratio`. The two groups of settings are mutually exclusive. Do not use them together)
 * @property sizingPolicy A value that controls scaling of thumbnails. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, and `ShrinkToFill`.
 */
public data class PresetThumbnails(
    public val aspectRatio: String? = null,
    public val format: String? = null,
    public val interval: String? = null,
    public val maxHeight: String? = null,
    public val maxWidth: String? = null,
    public val paddingPolicy: String? = null,
    public val resolution: String? = null,
    public val sizingPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PresetThumbnails):
            PresetThumbnails = PresetThumbnails(
            aspectRatio = javaType.aspectRatio().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            maxHeight = javaType.maxHeight().map({ args0 -> args0 }).orElse(null),
            maxWidth = javaType.maxWidth().map({ args0 -> args0 }).orElse(null),
            paddingPolicy = javaType.paddingPolicy().map({ args0 -> args0 }).orElse(null),
            resolution = javaType.resolution().map({ args0 -> args0 }).orElse(null),
            sizingPolicy = javaType.sizingPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
