@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AppCookieStickinessPolicy].
 */
@PulumiTagMarker
public class AppCookieStickinessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppCookieStickinessPolicyArgs = AppCookieStickinessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppCookieStickinessPolicyArgsBuilder.() -> Unit) {
        val builder = AppCookieStickinessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AppCookieStickinessPolicy {
        val builtJavaResource = com.pulumi.aws.elb.AppCookieStickinessPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppCookieStickinessPolicy(builtJavaResource)
    }
}

/**
 * Provides an application cookie stickiness policy, which allows an ELB to wed its sticky cookie's expiration to a cookie generated by your application.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.AppCookieStickinessPolicy;
 * import com.pulumi.aws.elb.AppCookieStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var foo = new AppCookieStickinessPolicy("foo", AppCookieStickinessPolicyArgs.builder()
 *             .loadBalancer(lb.name())
 *             .lbPort(80)
 *             .cookieName("MyAppCookie")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import application cookie stickiness policies using the ELB name, port, and policy name separated by colons (`:`). For example:
 * ```sh
 *  $ pulumi import aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy example my-elb:80:my-policy
 * ```
 *
 */
public class AppCookieStickinessPolicy internal constructor(
    override val javaResource: com.pulumi.aws.elb.AppCookieStickinessPolicy,
) : KotlinCustomResource(javaResource, AppCookieStickinessPolicyMapper) {
    /**
     * Application cookie whose lifetime the ELB's cookie should follow.
     */
    public val cookieName: Output<String>
        get() = javaResource.cookieName().applyValue({ args0 -> args0 })

    /**
     * Load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    public val lbPort: Output<Int>
        get() = javaResource.lbPort().applyValue({ args0 -> args0 })

    /**
     * Name of load balancer to which the policy
     * should be attached.
     */
    public val loadBalancer: Output<String>
        get() = javaResource.loadBalancer().applyValue({ args0 -> args0 })

    /**
     * Name of the stickiness policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object AppCookieStickinessPolicyMapper : ResourceMapper<AppCookieStickinessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.AppCookieStickinessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AppCookieStickinessPolicy =
        AppCookieStickinessPolicy(javaResource as com.pulumi.aws.elb.AppCookieStickinessPolicy)
}

/**
 * @see [AppCookieStickinessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppCookieStickinessPolicy].
 */
public suspend fun appCookieStickinessPolicy(
    name: String,
    block: suspend AppCookieStickinessPolicyResourceBuilder.() -> Unit,
): AppCookieStickinessPolicy {
    val builder = AppCookieStickinessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppCookieStickinessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appCookieStickinessPolicy(name: String): AppCookieStickinessPolicy {
    val builder = AppCookieStickinessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
