@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Attachment].
 */
@PulumiTagMarker
public class AttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AttachmentArgs = AttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AttachmentArgsBuilder.() -> Unit) {
        val builder = AttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Attachment {
        val builtJavaResource = com.pulumi.aws.elb.Attachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Attachment(builtJavaResource)
    }
}

/**
 * Attaches an EC2 instance to an Elastic Load Balancer (ELB). For attaching resources with Application Load Balancer (ALB) or Network Load Balancer (NLB), see the `aws.lb.TargetGroupAttachment` resource.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently provides
 * both a standalone ELB Attachment resource (describing an instance attached to
 * an ELB), and an Elastic Load Balancer resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with an ELB Attachment resource. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.Attachment;
 * import com.pulumi.aws.elb.AttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var baz = new Attachment("baz", AttachmentArgs.builder()
 *             .elb(aws_elb.bar().id())
 *             .instance(aws_instance.foo().id())
 *             .build());
 *     }
 * }
 * ```
 */
public class Attachment internal constructor(
    override val javaResource: com.pulumi.aws.elb.Attachment,
) : KotlinCustomResource(javaResource, AttachmentMapper) {
    /**
     * The name of the ELB.
     */
    public val elb: Output<String>
        get() = javaResource.elb().applyValue({ args0 -> args0 })

    /**
     * Instance ID to place in the ELB pool.
     */
    public val instance: Output<String>
        get() = javaResource.instance().applyValue({ args0 -> args0 })
}

public object AttachmentMapper : ResourceMapper<Attachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.Attachment::class == javaResource::class

    override fun map(javaResource: Resource): Attachment = Attachment(
        javaResource as
            com.pulumi.aws.elb.Attachment,
    )
}

/**
 * @see [Attachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Attachment].
 */
public suspend fun attachment(name: String, block: suspend AttachmentResourceBuilder.() -> Unit):
    Attachment {
    val builder = AttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Attachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun attachment(name: String): Attachment {
    val builder = AttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
