@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.AttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches an EC2 instance to an Elastic Load Balancer (ELB). For attaching resources with Application Load Balancer (ALB) or Network Load Balancer (NLB), see the `aws.lb.TargetGroupAttachment` resource.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently provides
 * both a standalone ELB Attachment resource (describing an instance attached to
 * an ELB), and an Elastic Load Balancer resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with an ELB Attachment resource. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.Attachment;
 * import com.pulumi.aws.elb.AttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var baz = new Attachment("baz", AttachmentArgs.builder()
 *             .elb(aws_elb.bar().id())
 *             .instance(aws_instance.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * @property elb The name of the ELB.
 * @property instance Instance ID to place in the ELB pool.
 */
public data class AttachmentArgs(
    public val elb: Output<String>? = null,
    public val instance: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.AttachmentArgs> {
    override fun toJava(): com.pulumi.aws.elb.AttachmentArgs =
        com.pulumi.aws.elb.AttachmentArgs.builder()
            .elb(elb?.applyValue({ args0 -> args0 }))
            .instance(instance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentArgs].
 */
@PulumiTagMarker
public class AttachmentArgsBuilder internal constructor() {
    private var elb: Output<String>? = null

    private var instance: Output<String>? = null

    /**
     * @param value The name of the ELB.
     */
    @JvmName("hpnaqnjhrhpajban")
    public suspend fun elb(`value`: Output<String>) {
        this.elb = value
    }

    /**
     * @param value Instance ID to place in the ELB pool.
     */
    @JvmName("knixunbhjtxkdsyx")
    public suspend fun instance(`value`: Output<String>) {
        this.instance = value
    }

    /**
     * @param value The name of the ELB.
     */
    @JvmName("bdiranhrvqwxekjl")
    public suspend fun elb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elb = mapped
    }

    /**
     * @param value Instance ID to place in the ELB pool.
     */
    @JvmName("cqkcedhrykojrltj")
    public suspend fun instance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instance = mapped
    }

    internal fun build(): AttachmentArgs = AttachmentArgs(
        elb = elb,
        instance = instance,
    )
}
