@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.ElbFunctions.getHostedZoneIdPlain
import com.pulumi.aws.elb.ElbFunctions.getLoadBalancerPlain
import com.pulumi.aws.elb.ElbFunctions.getServiceAccountPlain
import com.pulumi.aws.elb.kotlin.inputs.GetHostedZoneIdPlainArgs
import com.pulumi.aws.elb.kotlin.inputs.GetHostedZoneIdPlainArgsBuilder
import com.pulumi.aws.elb.kotlin.inputs.GetLoadBalancerPlainArgs
import com.pulumi.aws.elb.kotlin.inputs.GetLoadBalancerPlainArgsBuilder
import com.pulumi.aws.elb.kotlin.inputs.GetServiceAccountPlainArgs
import com.pulumi.aws.elb.kotlin.inputs.GetServiceAccountPlainArgsBuilder
import com.pulumi.aws.elb.kotlin.outputs.GetHostedZoneIdResult
import com.pulumi.aws.elb.kotlin.outputs.GetLoadBalancerResult
import com.pulumi.aws.elb.kotlin.outputs.GetServiceAccountResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.elb.kotlin.outputs.GetHostedZoneIdResult.Companion.toKotlin as getHostedZoneIdResultToKotlin
import com.pulumi.aws.elb.kotlin.outputs.GetLoadBalancerResult.Companion.toKotlin as getLoadBalancerResultToKotlin
import com.pulumi.aws.elb.kotlin.outputs.GetServiceAccountResult.Companion.toKotlin as getServiceAccountResultToKotlin

public object ElbFunctions {
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing HostedZoneId
     * in a given region for the purpose of using in an AWS Route53 Alias.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elb.ElbFunctions;
     * import com.pulumi.aws.elb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = ElbFunctions.getHostedZoneId();
     *         var www = new Record("www", RecordArgs.builder()
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name("example.com")
     *             .type("A")
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_elb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -> getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getHostedZoneId.
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(argument: GetHostedZoneIdPlainArgs): GetHostedZoneIdResult =
        getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(argument.toJava()).await())

    /**
     * @see [getHostedZoneId].
     * @param region Name of the region whose AWS ELB HostedZoneId is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(region: String? = null): GetHostedZoneIdResult {
        val argument = GetHostedZoneIdPlainArgs(
            region = region,
        )
        return getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostedZoneId].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elb&#46;kotlin&#46;inputs&#46;GetHostedZoneIdPlainArgs].
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(argument: suspend GetHostedZoneIdPlainArgsBuilder.() -> Unit):
        GetHostedZoneIdResult {
        val builder = GetHostedZoneIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a "classic" Elastic Load Balancer (ELB).
     * See LB Data Source if you are looking for "v2"
     * Application Load Balancer (ALB) or Network Load Balancer (NLB).
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elb.ElbFunctions;
     * import com.pulumi.aws.elb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbName = config.get("lbName").orElse("");
     *         final var test = ElbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(lbName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLoadBalancer.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: GetLoadBalancerPlainArgs): GetLoadBalancerResult =
        getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancer].
     * @param name Unique name of the load balancer.
     * @param tags
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(name: String, tags: Map<String, String>? = null):
        GetLoadBalancerResult {
        val argument = GetLoadBalancerPlainArgs(
            name = name,
            tags = tags,
        )
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elb&#46;kotlin&#46;inputs&#46;GetLoadBalancerPlainArgs].
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: suspend GetLoadBalancerPlainArgsBuilder.() -> Unit):
        GetLoadBalancerResult {
        val builder = GetLoadBalancerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the Account ID of the [AWS Elastic Load Balancing Service Account](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html#attach-bucket-policy)
     * in a given region for the purpose of permitting in S3 bucket policy.
     * > **Note:** For AWS Regions opened since Jakarta (`ap-southeast-3`) in December 2021, AWS [documents that](https://docs&#46;aws&#46;amazon&#46;com/elasticloadbalancing/latest/classic/enable-access-logs&#46;html#attach-bucket-policy) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elb.ElbFunctions;
     * import com.pulumi.aws.elb.inputs.GetServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import com.pulumi.aws.elb.LoadBalancer;
     * import com.pulumi.aws.elb.LoadBalancerArgs;
     * import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs;
     * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = ElbFunctions.getServiceAccount();
     *         var elbLogs = new BucketV2("elbLogs");
     *         var elbLogsAcl = new BucketAclV2("elbLogsAcl", BucketAclV2Args.builder()
     *             .bucket(elbLogs.id())
     *             .acl("private")
     *             .build());
     *         final var allowElbLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .type("AWS")
     *                     .identifiers(main.applyValue(getServiceAccountResult -> getServiceAccountResult.arn()))
     *                     .build())
     *                 .actions("s3:PutObject")
     *                 .resources(elbLogs.arn().applyValue(arn -> String.format("%s/AWSLogs/*", arn)))
     *                 .build())
     *             .build());
     *         var allowElbLoggingBucketPolicy = new BucketPolicy("allowElbLoggingBucketPolicy", BucketPolicyArgs.builder()
     *             .bucket(elbLogs.id())
     *             .policy(allowElbLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(allowElbLoggingPolicyDocument -> allowElbLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *         var bar = new LoadBalancer("bar", LoadBalancerArgs.builder()
     *             .availabilityZones("us-west-2a")
     *             .accessLogs(LoadBalancerAccessLogsArgs.builder()
     *                 .bucket(elbLogs.id())
     *                 .interval(5)
     *                 .build())
     *             .listeners(LoadBalancerListenerArgs.builder()
     *                 .instancePort(8000)
     *                 .instanceProtocol("http")
     *                 .lbPort(80)
     *                 .lbProtocol("http")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getServiceAccount.
     * @return A collection of values returned by getServiceAccount.
     * */
     */
    public suspend fun getServiceAccount(argument: GetServiceAccountPlainArgs):
        GetServiceAccountResult =
        getServiceAccountResultToKotlin(getServiceAccountPlain(argument.toJava()).await())

    /**
     * @see [getServiceAccount].
     * @param region Name of the region whose AWS ELB account ID is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend fun getServiceAccount(region: String? = null): GetServiceAccountResult {
        val argument = GetServiceAccountPlainArgs(
            region = region,
        )
        return getServiceAccountResultToKotlin(getServiceAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceAccount].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elb&#46;kotlin&#46;inputs&#46;GetServiceAccountPlainArgs].
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend
    fun getServiceAccount(argument: suspend GetServiceAccountPlainArgsBuilder.() -> Unit):
        GetServiceAccountResult {
        val builder = GetServiceAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceAccountResultToKotlin(getServiceAccountPlain(builtArgument.toJava()).await())
    }
}
