@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ListenerPolicy].
 */
@PulumiTagMarker
public class ListenerPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerPolicyArgs = ListenerPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerPolicyArgsBuilder.() -> Unit) {
        val builder = ListenerPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ListenerPolicy {
        val builtJavaResource = com.pulumi.aws.elb.ListenerPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ListenerPolicy(builtJavaResource)
    }
}

/**
 * Attaches a load balancer policy to an ELB Listener.
 * ## Example Usage
 * ### Custom Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.ListenerPolicy;
 * import com.pulumi.aws.elb.ListenerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ssl = new LoadBalancerPolicy("wu-tang-ssl", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ssl")
 *             .policyTypeName("SSLNegotiationPolicyType")
 *             .policyAttributes(
 *                 LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                     .name("ECDHE-ECDSA-AES128-GCM-SHA256")
 *                     .value("true")
 *                     .build(),
 *                 LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                     .name("Protocol-TLSv1.2")
 *                     .value("true")
 *                     .build())
 *             .build());
 *         var wu_tang_listener_policies_443 = new ListenerPolicy("wu-tang-listener-policies-443", ListenerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .loadBalancerPort(443)
 *             .policyNames(wu_tang_ssl.policyName())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Predefined Security Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.ListenerPolicy;
 * import com.pulumi.aws.elb.ListenerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ssl_tls_1_1 = new LoadBalancerPolicy("wu-tang-ssl-tls-1-1", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ssl")
 *             .policyTypeName("SSLNegotiationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("Reference-Security-Policy")
 *                 .value("ELBSecurityPolicy-TLS-1-1-2017-01")
 *                 .build())
 *             .build());
 *         var wu_tang_listener_policies_443 = new ListenerPolicy("wu-tang-listener-policies-443", ListenerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .loadBalancerPort(443)
 *             .policyNames(wu_tang_ssl_tls_1_1.policyName())
 *             .build());
 *     }
 * }
 * ```
 */
public class ListenerPolicy internal constructor(
    override val javaResource: com.pulumi.aws.elb.ListenerPolicy,
) : KotlinCustomResource(javaResource, ListenerPolicyMapper) {
    /**
     * The load balancer to attach the policy to.
     */
    public val loadBalancerName: Output<String>
        get() = javaResource.loadBalancerName().applyValue({ args0 -> args0 })

    /**
     * The load balancer listener port to apply the policy to.
     */
    public val loadBalancerPort: Output<Int>
        get() = javaResource.loadBalancerPort().applyValue({ args0 -> args0 })

    /**
     * List of Policy Names to apply to the backend server.
     */
    public val policyNames: Output<List<String>>?
        get() = javaResource.policyNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Map of arbitrary keys and values that, when changed, will trigger an update.
     */
    public val triggers: Output<Map<String, String>>?
        get() = javaResource.triggers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object ListenerPolicyMapper : ResourceMapper<ListenerPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.ListenerPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ListenerPolicy = ListenerPolicy(
        javaResource as
            com.pulumi.aws.elb.ListenerPolicy,
    )
}

/**
 * @see [ListenerPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerPolicy].
 */
public suspend fun listenerPolicy(
    name: String,
    block: suspend ListenerPolicyResourceBuilder.() -> Unit,
): ListenerPolicy {
    val builder = ListenerPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerPolicy(name: String): ListenerPolicy {
    val builder = ListenerPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
