@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.ListenerPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Attaches a load balancer policy to an ELB Listener.
 * ## Example Usage
 * ### Custom Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.ListenerPolicy;
 * import com.pulumi.aws.elb.ListenerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ssl = new LoadBalancerPolicy("wu-tang-ssl", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ssl")
 *             .policyTypeName("SSLNegotiationPolicyType")
 *             .policyAttributes(
 *                 LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                     .name("ECDHE-ECDSA-AES128-GCM-SHA256")
 *                     .value("true")
 *                     .build(),
 *                 LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                     .name("Protocol-TLSv1.2")
 *                     .value("true")
 *                     .build())
 *             .build());
 *         var wu_tang_listener_policies_443 = new ListenerPolicy("wu-tang-listener-policies-443", ListenerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .loadBalancerPort(443)
 *             .policyNames(wu_tang_ssl.policyName())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Predefined Security Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.ListenerPolicy;
 * import com.pulumi.aws.elb.ListenerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ssl_tls_1_1 = new LoadBalancerPolicy("wu-tang-ssl-tls-1-1", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ssl")
 *             .policyTypeName("SSLNegotiationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("Reference-Security-Policy")
 *                 .value("ELBSecurityPolicy-TLS-1-1-2017-01")
 *                 .build())
 *             .build());
 *         var wu_tang_listener_policies_443 = new ListenerPolicy("wu-tang-listener-policies-443", ListenerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .loadBalancerPort(443)
 *             .policyNames(wu_tang_ssl_tls_1_1.policyName())
 *             .build());
 *     }
 * }
 * ```
 * @property loadBalancerName The load balancer to attach the policy to.
 * @property loadBalancerPort The load balancer listener port to apply the policy to.
 * @property policyNames List of Policy Names to apply to the backend server.
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger an update.
 */
public data class ListenerPolicyArgs(
    public val loadBalancerName: Output<String>? = null,
    public val loadBalancerPort: Output<Int>? = null,
    public val policyNames: Output<List<String>>? = null,
    public val triggers: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.ListenerPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.ListenerPolicyArgs =
        com.pulumi.aws.elb.ListenerPolicyArgs.builder()
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .loadBalancerPort(loadBalancerPort?.applyValue({ args0 -> args0 }))
            .policyNames(policyNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListenerPolicyArgs].
 */
@PulumiTagMarker
public class ListenerPolicyArgsBuilder internal constructor() {
    private var loadBalancerName: Output<String>? = null

    private var loadBalancerPort: Output<Int>? = null

    private var policyNames: Output<List<String>>? = null

    private var triggers: Output<Map<String, String>>? = null

    /**
     * @param value The load balancer to attach the policy to.
     */
    @JvmName("fydleuimgpwsxghp")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The load balancer listener port to apply the policy to.
     */
    @JvmName("jqadasosofvbiuep")
    public suspend fun loadBalancerPort(`value`: Output<Int>) {
        this.loadBalancerPort = value
    }

    /**
     * @param value List of Policy Names to apply to the backend server.
     */
    @JvmName("nmvdktuyttmjcjnj")
    public suspend fun policyNames(`value`: Output<List<String>>) {
        this.policyNames = value
    }

    @JvmName("mchrtqedlbmitcyx")
    public suspend fun policyNames(vararg values: Output<String>) {
        this.policyNames = Output.all(values.asList())
    }

    /**
     * @param values List of Policy Names to apply to the backend server.
     */
    @JvmName("jerwugnhdsuxgavs")
    public suspend fun policyNames(values: List<Output<String>>) {
        this.policyNames = Output.all(values)
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger an update.
     */
    @JvmName("jypdchaetbxffdnx")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value The load balancer to attach the policy to.
     */
    @JvmName("ymvyrbxgdoiloovn")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The load balancer listener port to apply the policy to.
     */
    @JvmName("auysutnrsebssblr")
    public suspend fun loadBalancerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerPort = mapped
    }

    /**
     * @param value List of Policy Names to apply to the backend server.
     */
    @JvmName("fbojnncqelvxpxqe")
    public suspend fun policyNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyNames = mapped
    }

    /**
     * @param values List of Policy Names to apply to the backend server.
     */
    @JvmName("fkqmxuegaqrvrdwj")
    public suspend fun policyNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyNames = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger an update.
     */
    @JvmName("lvpmmtpmcfiqyapk")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger an update.
     */
    @JvmName("isbenuwtgpmxxssh")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): ListenerPolicyArgs = ListenerPolicyArgs(
        loadBalancerName = loadBalancerName,
        loadBalancerPort = loadBalancerPort,
        policyNames = policyNames,
        triggers = triggers,
    )
}
