@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerAccessLogs
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerHealthCheck
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerListener
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerAccessLogs.Companion.toKotlin as loadBalancerAccessLogsToKotlin
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerHealthCheck.Companion.toKotlin as loadBalancerHealthCheckToKotlin
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerListener.Companion.toKotlin as loadBalancerListenerToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource = com.pulumi.aws.elb.LoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * Provides an Elastic Load Balancer resource, also known as a "Classic
 * Load Balancer" after the release of
 * Application/Network Load Balancers.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently
 * provides both a standalone ELB Attachment resource
 * (describing an instance attached to an ELB), and an ELB resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with a ELB Attachment resources. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new LoadBalancer("bar", LoadBalancerArgs.builder()
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .accessLogs(LoadBalancerAccessLogsArgs.builder()
 *                 .bucket("foo")
 *                 .bucketPrefix("bar")
 *                 .interval(60)
 *                 .build())
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(80)
 *                     .lbProtocol("http")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(443)
 *                     .lbProtocol("https")
 *                     .sslCertificateId("arn:aws:iam::123456789012:server-certificate/certName")
 *                     .build())
 *             .healthCheck(LoadBalancerHealthCheckArgs.builder()
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .timeout(3)
 *                 .target("HTTP:8000/")
 *                 .interval(30)
 *                 .build())
 *             .instances(aws_instance.foo().id())
 *             .crossZoneLoadBalancing(true)
 *             .idleTimeout(400)
 *             .connectionDraining(true)
 *             .connectionDrainingTimeout(400)
 *             .tags(Map.of("Name", "foobar-elb"))
 *             .build());
 *     }
 * }
 * ```
 * ## Note on ECDSA Key Algorithm
 * If the ARN of the `ssl_certificate_id` that is pointed to references a
 * certificate that was signed by an ECDSA key, note that ELB only supports the
 * P256 and P384 curves.  Using a certificate signed by a key using a different
 * curve could produce the error `ERR_SSL_VERSION_OR_CIPHER_MISMATCH` in your
 * browser.
 * ## Import
 * Using `pulumi import`, import ELBs using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:elb/loadBalancer:LoadBalancer bar elb-production-12345
 * ```
 *
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.aws.elb.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * An Access Logs block. Access Logs documented below.
     */
    public val accessLogs: Output<LoadBalancerAccessLogs>?
        get() = javaResource.accessLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerAccessLogsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ARN of the ELB
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AZ's to serve traffic in.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Boolean to enable connection draining. Default: `false`
     */
    public val connectionDraining: Output<Boolean>?
        get() = javaResource.connectionDraining().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in seconds to allow for connections to drain. Default: `300`
     */
    public val connectionDrainingTimeout: Output<Int>?
        get() = javaResource.connectionDrainingTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable cross-zone load balancing. Default: `true`
     */
    public val crossZoneLoadBalancing: Output<Boolean>?
        get() = javaResource.crossZoneLoadBalancing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    public val desyncMitigationMode: Output<String>?
        get() = javaResource.desyncMitigationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DNS name of the ELB
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * A health_check block. Health Check documented below.
     */
    public val healthCheck: Output<LoadBalancerHealthCheck>
        get() = javaResource.healthCheck().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerHealthCheckToKotlin(args0)
            })
        })

    /**
     * The time in seconds that the connection is allowed to be idle. Default: `60`
     */
    public val idleTimeout: Output<Int>?
        get() = javaResource.idleTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of instance ids to place in the ELB pool.
     */
    public val instances: Output<List<String>>
        get() = javaResource.instances().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * If true, ELB will be an internal ELB.
     */
    public val `internal`: Output<Boolean>
        get() = javaResource.`internal`().applyValue({ args0 -> args0 })

    /**
     * A list of listener blocks. Listeners documented below.
     */
    public val listeners: Output<List<LoadBalancerListener>>
        get() = javaResource.listeners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerListenerToKotlin(args0)
                })
            })
        })

    /**
     * The name of the ELB. By default generated by this provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Use this for Classic or Default VPC only.
     */
    public val sourceSecurityGroup: Output<String>
        get() = javaResource.sourceSecurityGroup().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Only available on ELBs launched in a VPC.
     */
    public val sourceSecurityGroupId: Output<String>
        get() = javaResource.sourceSecurityGroupId().applyValue({ args0 -> args0 })

    /**
     * A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    public val subnets: Output<List<String>>
        get() = javaResource.subnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The canonical hosted zone ID of the ELB (to be used in a Route 53 Alias record)
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.aws.elb.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
