@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.LoadBalancerArgs.builder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerAccessLogsArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerAccessLogsArgsBuilder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerHealthCheckArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerHealthCheckArgsBuilder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerListenerArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerListenerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Load Balancer resource, also known as a "Classic
 * Load Balancer" after the release of
 * Application/Network Load Balancers.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently
 * provides both a standalone ELB Attachment resource
 * (describing an instance attached to an ELB), and an ELB resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with a ELB Attachment resources. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new LoadBalancer("bar", LoadBalancerArgs.builder()
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .accessLogs(LoadBalancerAccessLogsArgs.builder()
 *                 .bucket("foo")
 *                 .bucketPrefix("bar")
 *                 .interval(60)
 *                 .build())
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(80)
 *                     .lbProtocol("http")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(443)
 *                     .lbProtocol("https")
 *                     .sslCertificateId("arn:aws:iam::123456789012:server-certificate/certName")
 *                     .build())
 *             .healthCheck(LoadBalancerHealthCheckArgs.builder()
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .timeout(3)
 *                 .target("HTTP:8000/")
 *                 .interval(30)
 *                 .build())
 *             .instances(aws_instance.foo().id())
 *             .crossZoneLoadBalancing(true)
 *             .idleTimeout(400)
 *             .connectionDraining(true)
 *             .connectionDrainingTimeout(400)
 *             .tags(Map.of("Name", "foobar-elb"))
 *             .build());
 *     }
 * }
 * ```
 * ## Note on ECDSA Key Algorithm
 * If the ARN of the `ssl_certificate_id` that is pointed to references a
 * certificate that was signed by an ECDSA key, note that ELB only supports the
 * P256 and P384 curves.  Using a certificate signed by a key using a different
 * curve could produce the error `ERR_SSL_VERSION_OR_CIPHER_MISMATCH` in your
 * browser.
 * ## Import
 * Using `pulumi import`, import ELBs using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:elb/loadBalancer:LoadBalancer bar elb-production-12345
 * ```
 * @property accessLogs An Access Logs block. Access Logs documented below.
 * @property availabilityZones The AZ's to serve traffic in.
 * @property connectionDraining Boolean to enable connection draining. Default: `false`
 * @property connectionDrainingTimeout The time in seconds to allow for connections to drain. Default: `300`
 * @property crossZoneLoadBalancing Enable cross-zone load balancing. Default: `true`
 * @property desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
 * @property healthCheck A health_check block. Health Check documented below.
 * @property idleTimeout The time in seconds that the connection is allowed to be idle. Default: `60`
 * @property instances A list of instance ids to place in the ELB pool.
 * @property internal If true, ELB will be an internal ELB.
 * @property listeners A list of listener blocks. Listeners documented below.
 * @property name The name of the ELB. By default generated by this provider.
 * @property namePrefix Creates a unique name beginning with the specified
 * prefix. Conflicts with `name`.
 * @property securityGroups A list of security group IDs to assign to the ELB.
 * Only valid if creating an ELB within a VPC
 * @property sourceSecurityGroup The name of the security group that you can use as
 * part of your inbound rules for your load balancer's back-end application
 * instances. Use this for Classic or Default VPC only.
 * @property subnets A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * Exactly one of `availability_zones` or `subnets` must be specified: this
 * determines if the ELB exists in a VPC or in EC2-classic.
 */
public data class LoadBalancerArgs(
    public val accessLogs: Output<LoadBalancerAccessLogsArgs>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val connectionDraining: Output<Boolean>? = null,
    public val connectionDrainingTimeout: Output<Int>? = null,
    public val crossZoneLoadBalancing: Output<Boolean>? = null,
    public val desyncMitigationMode: Output<String>? = null,
    public val healthCheck: Output<LoadBalancerHealthCheckArgs>? = null,
    public val idleTimeout: Output<Int>? = null,
    public val instances: Output<List<String>>? = null,
    public val `internal`: Output<Boolean>? = null,
    public val listeners: Output<List<LoadBalancerListenerArgs>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sourceSecurityGroup: Output<String>? = null,
    public val subnets: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.aws.elb.LoadBalancerArgs =
        com.pulumi.aws.elb.LoadBalancerArgs.builder()
            .accessLogs(accessLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectionDraining(connectionDraining?.applyValue({ args0 -> args0 }))
            .connectionDrainingTimeout(connectionDrainingTimeout?.applyValue({ args0 -> args0 }))
            .crossZoneLoadBalancing(crossZoneLoadBalancing?.applyValue({ args0 -> args0 }))
            .desyncMitigationMode(desyncMitigationMode?.applyValue({ args0 -> args0 }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .instances(instances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`internal`(`internal`?.applyValue({ args0 -> args0 }))
            .listeners(
                listeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceSecurityGroup(sourceSecurityGroup?.applyValue({ args0 -> args0 }))
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var accessLogs: Output<LoadBalancerAccessLogsArgs>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var connectionDraining: Output<Boolean>? = null

    private var connectionDrainingTimeout: Output<Int>? = null

    private var crossZoneLoadBalancing: Output<Boolean>? = null

    private var desyncMitigationMode: Output<String>? = null

    private var healthCheck: Output<LoadBalancerHealthCheckArgs>? = null

    private var idleTimeout: Output<Int>? = null

    private var instances: Output<List<String>>? = null

    private var `internal`: Output<Boolean>? = null

    private var listeners: Output<List<LoadBalancerListenerArgs>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sourceSecurityGroup: Output<String>? = null

    private var subnets: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An Access Logs block. Access Logs documented below.
     */
    @JvmName("pengphmnflabllhf")
    public suspend fun accessLogs(`value`: Output<LoadBalancerAccessLogsArgs>) {
        this.accessLogs = value
    }

    /**
     * @param value The AZ's to serve traffic in.
     */
    @JvmName("krroaglvnghvxtgw")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("miuofsrhbyugmrnk")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The AZ's to serve traffic in.
     */
    @JvmName("hasmehobtlfwkgyt")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Boolean to enable connection draining. Default: `false`
     */
    @JvmName("dpwengtpetwymcwo")
    public suspend fun connectionDraining(`value`: Output<Boolean>) {
        this.connectionDraining = value
    }

    /**
     * @param value The time in seconds to allow for connections to drain. Default: `300`
     */
    @JvmName("hyfqnjlopadsijhn")
    public suspend fun connectionDrainingTimeout(`value`: Output<Int>) {
        this.connectionDrainingTimeout = value
    }

    /**
     * @param value Enable cross-zone load balancing. Default: `true`
     */
    @JvmName("kbndcmtyyyshblcn")
    public suspend fun crossZoneLoadBalancing(`value`: Output<Boolean>) {
        this.crossZoneLoadBalancing = value
    }

    /**
     * @param value Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    @JvmName("akuycpixucatkdfk")
    public suspend fun desyncMitigationMode(`value`: Output<String>) {
        this.desyncMitigationMode = value
    }

    /**
     * @param value A health_check block. Health Check documented below.
     */
    @JvmName("urqfbagepbfkgbgj")
    public suspend fun healthCheck(`value`: Output<LoadBalancerHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value The time in seconds that the connection is allowed to be idle. Default: `60`
     */
    @JvmName("hxxednmaryiopqef")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value A list of instance ids to place in the ELB pool.
     */
    @JvmName("kbfnbgnjgcvqneoe")
    public suspend fun instances(`value`: Output<List<String>>) {
        this.instances = value
    }

    @JvmName("qbwkhepphublnehs")
    public suspend fun instances(vararg values: Output<String>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values A list of instance ids to place in the ELB pool.
     */
    @JvmName("bvdlnebawoysbnbu")
    public suspend fun instances(values: List<Output<String>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value If true, ELB will be an internal ELB.
     */
    @JvmName("jrwmcwyqahtbigvp")
    public suspend fun `internal`(`value`: Output<Boolean>) {
        this.`internal` = value
    }

    /**
     * @param value A list of listener blocks. Listeners documented below.
     */
    @JvmName("whvytgrowlmfcypy")
    public suspend fun listeners(`value`: Output<List<LoadBalancerListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("ovsouffbanmgjdco")
    public suspend fun listeners(vararg values: Output<LoadBalancerListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values A list of listener blocks. Listeners documented below.
     */
    @JvmName("amnxwugkwimpqkyv")
    public suspend fun listeners(values: List<Output<LoadBalancerListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value The name of the ELB. By default generated by this provider.
     */
    @JvmName("qymlubqdfaxlfipv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("vnhpiktbtgtbdxfa")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("gldpcgirajluufjo")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("vclvagkofpqkvqpo")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("ctvgaoowecptblbt")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The name of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Use this for Classic or Default VPC only.
     */
    @JvmName("xvhjhdiudjawtgug")
    public suspend fun sourceSecurityGroup(`value`: Output<String>) {
        this.sourceSecurityGroup = value
    }

    /**
     * @param value A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("kgmdeboblffykfvm")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("wrldgmiquechugcm")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("wfdbblwlkkrcsdvi")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    @JvmName("vtmsgjqjxaevoxxl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An Access Logs block. Access Logs documented below.
     */
    @JvmName("pfygddkrismpxiev")
    public suspend fun accessLogs(`value`: LoadBalancerAccessLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogs = mapped
    }

    /**
     * @param argument An Access Logs block. Access Logs documented below.
     */
    @JvmName("atafsdtvjxxnqrlj")
    public suspend fun accessLogs(argument: suspend LoadBalancerAccessLogsArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerAccessLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogs = mapped
    }

    /**
     * @param value The AZ's to serve traffic in.
     */
    @JvmName("eyyrkcpshktdqxkv")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The AZ's to serve traffic in.
     */
    @JvmName("cudvqbybckiuxnki")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Boolean to enable connection draining. Default: `false`
     */
    @JvmName("rkhttlqpqlpjqxyc")
    public suspend fun connectionDraining(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDraining = mapped
    }

    /**
     * @param value The time in seconds to allow for connections to drain. Default: `300`
     */
    @JvmName("hhupgrheqjbycxbc")
    public suspend fun connectionDrainingTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDrainingTimeout = mapped
    }

    /**
     * @param value Enable cross-zone load balancing. Default: `true`
     */
    @JvmName("hpqnaeoxnyxvfgys")
    public suspend fun crossZoneLoadBalancing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossZoneLoadBalancing = mapped
    }

    /**
     * @param value Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    @JvmName("vquiieivigwqomkk")
    public suspend fun desyncMitigationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desyncMitigationMode = mapped
    }

    /**
     * @param value A health_check block. Health Check documented below.
     */
    @JvmName("ccmbrrikayerfcht")
    public suspend fun healthCheck(`value`: LoadBalancerHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument A health_check block. Health Check documented below.
     */
    @JvmName("npmnmcpypfyjrale")
    public suspend fun healthCheck(argument: suspend LoadBalancerHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerHealthCheckArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value The time in seconds that the connection is allowed to be idle. Default: `60`
     */
    @JvmName("rrpbrjqnrsifogss")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value A list of instance ids to place in the ELB pool.
     */
    @JvmName("sswebbqgpsgxjxmk")
    public suspend fun instances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param values A list of instance ids to place in the ELB pool.
     */
    @JvmName("nevbasnpvyblaihm")
    public suspend fun instances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value If true, ELB will be an internal ELB.
     */
    @JvmName("brgnxikptpprwekw")
    public suspend fun `internal`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`internal` = mapped
    }

    /**
     * @param value A list of listener blocks. Listeners documented below.
     */
    @JvmName("xvcetvhndohgmjsc")
    public suspend fun listeners(`value`: List<LoadBalancerListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument A list of listener blocks. Listeners documented below.
     */
    @JvmName("fqncbrdrpivlmjym")
    public suspend fun listeners(argument: List<suspend LoadBalancerListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument A list of listener blocks. Listeners documented below.
     */
    @JvmName("cvgbeefjthcxgsqa")
    public suspend fun listeners(
        vararg
        argument: suspend LoadBalancerListenerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument A list of listener blocks. Listeners documented below.
     */
    @JvmName("kivhwlnudvpeoubl")
    public suspend fun listeners(argument: suspend LoadBalancerListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoadBalancerListenerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values A list of listener blocks. Listeners documented below.
     */
    @JvmName("hwymeqtituqhjkrr")
    public suspend fun listeners(vararg values: LoadBalancerListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param value The name of the ELB. By default generated by this provider.
     */
    @JvmName("obgtjvexlpblrnun")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("jaktrimlixhjlvtq")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("tiiauiiclqyjauis")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("myaelhrwddxilgev")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The name of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Use this for Classic or Default VPC only.
     */
    @JvmName("rgymnvqolcajwlbv")
    public suspend fun sourceSecurityGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSecurityGroup = mapped
    }

    /**
     * @param value A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("madwhwgegvlovpyw")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("mqhweidakstdegaa")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    @JvmName("aossoinrxpahcrmq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    @JvmName("nxgpdgqprqvnkxrv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        accessLogs = accessLogs,
        availabilityZones = availabilityZones,
        connectionDraining = connectionDraining,
        connectionDrainingTimeout = connectionDrainingTimeout,
        crossZoneLoadBalancing = crossZoneLoadBalancing,
        desyncMitigationMode = desyncMitigationMode,
        healthCheck = healthCheck,
        idleTimeout = idleTimeout,
        instances = instances,
        `internal` = `internal`,
        listeners = listeners,
        name = name,
        namePrefix = namePrefix,
        securityGroups = securityGroups,
        sourceSecurityGroup = sourceSecurityGroup,
        subnets = subnets,
        tags = tags,
    )
}
