@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LoadBalancerBackendServerPolicy].
 */
@PulumiTagMarker
public class LoadBalancerBackendServerPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerBackendServerPolicyArgs = LoadBalancerBackendServerPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerBackendServerPolicyArgsBuilder.() -> Unit) {
        val builder = LoadBalancerBackendServerPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LoadBalancerBackendServerPolicy {
        val builtJavaResource =
            com.pulumi.aws.elb.LoadBalancerBackendServerPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancerBackendServerPolicy(builtJavaResource)
    }
}

/**
 * Attaches a load balancer policy to an ELB backend server.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ca_pubkey_policy = new LoadBalancerPolicy("wu-tang-ca-pubkey-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ca-pubkey-policy")
 *             .policyTypeName("PublicKeyPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKey")
 *                 .value(Files.readString(Paths.get("wu-tang-pubkey")))
 *                 .build())
 *             .build());
 *         var wu_tang_root_ca_backend_auth_policy = new LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-root-ca-backend-auth-policy")
 *             .policyTypeName("BackendServerAuthenticationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKeyPolicyName")
 *                 .value(aws_load_balancer_policy.wu-tang-root-ca-pubkey-policy().policy_name())
 *                 .build())
 *             .build());
 *         var wu_tang_backend_auth_policies_443 = new LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443", LoadBalancerBackendServerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .instancePort(443)
 *             .policyNames(wu_tang_root_ca_backend_auth_policy.policyName())
 *             .build());
 *     }
 * }
 * ```
 */
public class LoadBalancerBackendServerPolicy internal constructor(
    override val javaResource: com.pulumi.aws.elb.LoadBalancerBackendServerPolicy,
) : KotlinCustomResource(javaResource, LoadBalancerBackendServerPolicyMapper) {
    /**
     * The instance port to apply the policy to.
     */
    public val instancePort: Output<Int>
        get() = javaResource.instancePort().applyValue({ args0 -> args0 })

    /**
     * The load balancer to attach the policy to.
     */
    public val loadBalancerName: Output<String>
        get() = javaResource.loadBalancerName().applyValue({ args0 -> args0 })

    /**
     * List of Policy Names to apply to the backend server.
     */
    public val policyNames: Output<List<String>>?
        get() = javaResource.policyNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object LoadBalancerBackendServerPolicyMapper :
    ResourceMapper<LoadBalancerBackendServerPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.LoadBalancerBackendServerPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancerBackendServerPolicy =
        LoadBalancerBackendServerPolicy(
            javaResource as
                com.pulumi.aws.elb.LoadBalancerBackendServerPolicy,
        )
}

/**
 * @see [LoadBalancerBackendServerPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancerBackendServerPolicy].
 */
public suspend fun loadBalancerBackendServerPolicy(
    name: String,
    block: suspend LoadBalancerBackendServerPolicyResourceBuilder.() -> Unit,
):
    LoadBalancerBackendServerPolicy {
    val builder = LoadBalancerBackendServerPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancerBackendServerPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancerBackendServerPolicy(name: String): LoadBalancerBackendServerPolicy {
    val builder = LoadBalancerBackendServerPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
