@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Attaches a load balancer policy to an ELB backend server.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ca_pubkey_policy = new LoadBalancerPolicy("wu-tang-ca-pubkey-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ca-pubkey-policy")
 *             .policyTypeName("PublicKeyPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKey")
 *                 .value(Files.readString(Paths.get("wu-tang-pubkey")))
 *                 .build())
 *             .build());
 *         var wu_tang_root_ca_backend_auth_policy = new LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-root-ca-backend-auth-policy")
 *             .policyTypeName("BackendServerAuthenticationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKeyPolicyName")
 *                 .value(aws_load_balancer_policy.wu-tang-root-ca-pubkey-policy().policy_name())
 *                 .build())
 *             .build());
 *         var wu_tang_backend_auth_policies_443 = new LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443", LoadBalancerBackendServerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .instancePort(443)
 *             .policyNames(wu_tang_root_ca_backend_auth_policy.policyName())
 *             .build());
 *     }
 * }
 * ```
 * @property instancePort The instance port to apply the policy to.
 * @property loadBalancerName The load balancer to attach the policy to.
 * @property policyNames List of Policy Names to apply to the backend server.
 */
public data class LoadBalancerBackendServerPolicyArgs(
    public val instancePort: Output<Int>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val policyNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs =
        com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs.builder()
            .instancePort(instancePort?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .policyNames(policyNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LoadBalancerBackendServerPolicyArgs].
 */
@PulumiTagMarker
public class LoadBalancerBackendServerPolicyArgsBuilder internal constructor() {
    private var instancePort: Output<Int>? = null

    private var loadBalancerName: Output<String>? = null

    private var policyNames: Output<List<String>>? = null

    /**
     * @param value The instance port to apply the policy to.
     */
    @JvmName("ypquupmmewxbdqpp")
    public suspend fun instancePort(`value`: Output<Int>) {
        this.instancePort = value
    }

    /**
     * @param value The load balancer to attach the policy to.
     */
    @JvmName("cgyqkmrnryhfqawn")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value List of Policy Names to apply to the backend server.
     */
    @JvmName("fuhdpqddllgfmrda")
    public suspend fun policyNames(`value`: Output<List<String>>) {
        this.policyNames = value
    }

    @JvmName("jkjutvjwnmvhppcy")
    public suspend fun policyNames(vararg values: Output<String>) {
        this.policyNames = Output.all(values.asList())
    }

    /**
     * @param values List of Policy Names to apply to the backend server.
     */
    @JvmName("ogdbmbefdxyikudv")
    public suspend fun policyNames(values: List<Output<String>>) {
        this.policyNames = Output.all(values)
    }

    /**
     * @param value The instance port to apply the policy to.
     */
    @JvmName("bctwhlphyscybntu")
    public suspend fun instancePort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePort = mapped
    }

    /**
     * @param value The load balancer to attach the policy to.
     */
    @JvmName("cnbiqksxsmrcswju")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value List of Policy Names to apply to the backend server.
     */
    @JvmName("vdgknbthybygmhnd")
    public suspend fun policyNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyNames = mapped
    }

    /**
     * @param values List of Policy Names to apply to the backend server.
     */
    @JvmName("ngvkxdpmhmoidvkg")
    public suspend fun policyNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyNames = mapped
    }

    internal fun build(): LoadBalancerBackendServerPolicyArgs = LoadBalancerBackendServerPolicyArgs(
        instancePort = instancePort,
        loadBalancerName = loadBalancerName,
        policyNames = policyNames,
    )
}
