@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LoadBalancerCookieStickinessPolicy].
 */
@PulumiTagMarker
public class LoadBalancerCookieStickinessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerCookieStickinessPolicyArgs = LoadBalancerCookieStickinessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerCookieStickinessPolicyArgsBuilder.() -> Unit) {
        val builder = LoadBalancerCookieStickinessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LoadBalancerCookieStickinessPolicy {
        val builtJavaResource =
            com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancerCookieStickinessPolicy(builtJavaResource)
    }
}

/**
 * Provides a load balancer cookie stickiness policy, which allows an ELB to control the sticky session lifetime of the browser.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy;
 * import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var foo = new LoadBalancerCookieStickinessPolicy("foo", LoadBalancerCookieStickinessPolicyArgs.builder()
 *             .loadBalancer(lb.id())
 *             .lbPort(80)
 *             .cookieExpirationPeriod(600)
 *             .build());
 *     }
 * }
 * ```
 */
public class LoadBalancerCookieStickinessPolicy internal constructor(
    override val javaResource: com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy,
) : KotlinCustomResource(javaResource, LoadBalancerCookieStickinessPolicyMapper) {
    /**
     * The time period after which
     * the session cookie should be considered stale, expressed in seconds.
     */
    public val cookieExpirationPeriod: Output<Int>?
        get() = javaResource.cookieExpirationPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    public val lbPort: Output<Int>
        get() = javaResource.lbPort().applyValue({ args0 -> args0 })

    /**
     * The load balancer to which the policy
     * should be attached.
     */
    public val loadBalancer: Output<String>
        get() = javaResource.loadBalancer().applyValue({ args0 -> args0 })

    /**
     * The name of the stickiness policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object LoadBalancerCookieStickinessPolicyMapper :
    ResourceMapper<LoadBalancerCookieStickinessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancerCookieStickinessPolicy =
        LoadBalancerCookieStickinessPolicy(
            javaResource as
                com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy,
        )
}

/**
 * @see [LoadBalancerCookieStickinessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancerCookieStickinessPolicy].
 */
public suspend fun loadBalancerCookieStickinessPolicy(
    name: String,
    block: suspend LoadBalancerCookieStickinessPolicyResourceBuilder.() -> Unit,
):
    LoadBalancerCookieStickinessPolicy {
    val builder = LoadBalancerCookieStickinessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancerCookieStickinessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancerCookieStickinessPolicy(name: String): LoadBalancerCookieStickinessPolicy {
    val builder = LoadBalancerCookieStickinessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
