@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a load balancer cookie stickiness policy, which allows an ELB to control the sticky session lifetime of the browser.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy;
 * import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var foo = new LoadBalancerCookieStickinessPolicy("foo", LoadBalancerCookieStickinessPolicyArgs.builder()
 *             .loadBalancer(lb.id())
 *             .lbPort(80)
 *             .cookieExpirationPeriod(600)
 *             .build());
 *     }
 * }
 * ```
 * @property cookieExpirationPeriod The time period after which
 * the session cookie should be considered stale, expressed in seconds.
 * @property lbPort The load balancer port to which the policy
 * should be applied. This must be an active listener on the load
 * balancer.
 * @property loadBalancer The load balancer to which the policy
 * should be attached.
 * @property name The name of the stickiness policy.
 */
public data class LoadBalancerCookieStickinessPolicyArgs(
    public val cookieExpirationPeriod: Output<Int>? = null,
    public val lbPort: Output<Int>? = null,
    public val loadBalancer: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs =
        com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs.builder()
            .cookieExpirationPeriod(cookieExpirationPeriod?.applyValue({ args0 -> args0 }))
            .lbPort(lbPort?.applyValue({ args0 -> args0 }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerCookieStickinessPolicyArgs].
 */
@PulumiTagMarker
public class LoadBalancerCookieStickinessPolicyArgsBuilder internal constructor() {
    private var cookieExpirationPeriod: Output<Int>? = null

    private var lbPort: Output<Int>? = null

    private var loadBalancer: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The time period after which
     * the session cookie should be considered stale, expressed in seconds.
     */
    @JvmName("uveectlbjfbhyaim")
    public suspend fun cookieExpirationPeriod(`value`: Output<Int>) {
        this.cookieExpirationPeriod = value
    }

    /**
     * @param value The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("mhiryigafrrakwio")
    public suspend fun lbPort(`value`: Output<Int>) {
        this.lbPort = value
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("ihmnjipdnnuimtau")
    public suspend fun loadBalancer(`value`: Output<String>) {
        this.loadBalancer = value
    }

    /**
     * @param value The name of the stickiness policy.
     */
    @JvmName("qxfcjgewbiqwakff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The time period after which
     * the session cookie should be considered stale, expressed in seconds.
     */
    @JvmName("idfvdjnhwxuxnicf")
    public suspend fun cookieExpirationPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieExpirationPeriod = mapped
    }

    /**
     * @param value The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("iclmwoeognvoxlxc")
    public suspend fun lbPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbPort = mapped
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("fkxwmkqhdkmmxwmu")
    public suspend fun loadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    /**
     * @param value The name of the stickiness policy.
     */
    @JvmName("xjbxufjrlfpkwvft")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LoadBalancerCookieStickinessPolicyArgs =
        LoadBalancerCookieStickinessPolicyArgs(
            cookieExpirationPeriod = cookieExpirationPeriod,
            lbPort = lbPort,
            loadBalancer = loadBalancer,
            name = name,
        )
}
