@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.LoadBalancerPolicyArgs.builder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerPolicyPolicyAttributeArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerPolicyPolicyAttributeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a load balancer policy, which can be attached to an ELB listener or backend server.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs;
 * import com.pulumi.aws.elb.ListenerPolicy;
 * import com.pulumi.aws.elb.ListenerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ca_pubkey_policy = new LoadBalancerPolicy("wu-tang-ca-pubkey-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ca-pubkey-policy")
 *             .policyTypeName("PublicKeyPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKey")
 *                 .value(Files.readString(Paths.get("wu-tang-pubkey")))
 *                 .build())
 *             .build());
 *         var wu_tang_root_ca_backend_auth_policy = new LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-root-ca-backend-auth-policy")
 *             .policyTypeName("BackendServerAuthenticationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKeyPolicyName")
 *                 .value(aws_load_balancer_policy.wu-tang-root-ca-pubkey-policy().policy_name())
 *                 .build())
 *             .build());
 *         var wu_tang_ssl = new LoadBalancerPolicy("wu-tang-ssl", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ssl")
 *             .policyTypeName("SSLNegotiationPolicyType")
 *             .policyAttributes(
 *                 LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                     .name("ECDHE-ECDSA-AES128-GCM-SHA256")
 *                     .value("true")
 *                     .build(),
 *                 LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                     .name("Protocol-TLSv1.2")
 *                     .value("true")
 *                     .build())
 *             .build());
 *         var wu_tang_ssl_tls_1_1 = new LoadBalancerPolicy("wu-tang-ssl-tls-1-1", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ssl")
 *             .policyTypeName("SSLNegotiationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("Reference-Security-Policy")
 *                 .value("ELBSecurityPolicy-TLS-1-1-2017-01")
 *                 .build())
 *             .build());
 *         var wu_tang_backend_auth_policies_443 = new LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443", LoadBalancerBackendServerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .instancePort(443)
 *             .policyNames(wu_tang_root_ca_backend_auth_policy.policyName())
 *             .build());
 *         var wu_tang_listener_policies_443 = new ListenerPolicy("wu-tang-listener-policies-443", ListenerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .loadBalancerPort(443)
 *             .policyNames(wu_tang_ssl.policyName())
 *             .build());
 *     }
 * }
 * ```
 * @property loadBalancerName The load balancer on which the policy is defined.
 * @property policyAttributes Policy attribute to apply to the policy.
 * @property policyName The name of the load balancer policy.
 * @property policyTypeName The policy type.
 */
public data class LoadBalancerPolicyArgs(
    public val loadBalancerName: Output<String>? = null,
    public val policyAttributes: Output<List<LoadBalancerPolicyPolicyAttributeArgs>>? = null,
    public val policyName: Output<String>? = null,
    public val policyTypeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.LoadBalancerPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.LoadBalancerPolicyArgs =
        com.pulumi.aws.elb.LoadBalancerPolicyArgs.builder()
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .policyAttributes(
                policyAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policyTypeName(policyTypeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerPolicyArgs].
 */
@PulumiTagMarker
public class LoadBalancerPolicyArgsBuilder internal constructor() {
    private var loadBalancerName: Output<String>? = null

    private var policyAttributes: Output<List<LoadBalancerPolicyPolicyAttributeArgs>>? = null

    private var policyName: Output<String>? = null

    private var policyTypeName: Output<String>? = null

    /**
     * @param value The load balancer on which the policy is defined.
     */
    @JvmName("sgvqinfwsobowbbu")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value Policy attribute to apply to the policy.
     */
    @JvmName("qbakdbvujslrmcem")
    public suspend
    fun policyAttributes(`value`: Output<List<LoadBalancerPolicyPolicyAttributeArgs>>) {
        this.policyAttributes = value
    }

    @JvmName("bnoxmqmkituihqfb")
    public suspend fun policyAttributes(
        vararg
        values: Output<LoadBalancerPolicyPolicyAttributeArgs>,
    ) {
        this.policyAttributes = Output.all(values.asList())
    }

    /**
     * @param values Policy attribute to apply to the policy.
     */
    @JvmName("aefifgguektajiww")
    public suspend fun policyAttributes(values: List<Output<LoadBalancerPolicyPolicyAttributeArgs>>) {
        this.policyAttributes = Output.all(values)
    }

    /**
     * @param value The name of the load balancer policy.
     */
    @JvmName("dthxolonyjshxgnv")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The policy type.
     */
    @JvmName("vdskspnklgjkwtru")
    public suspend fun policyTypeName(`value`: Output<String>) {
        this.policyTypeName = value
    }

    /**
     * @param value The load balancer on which the policy is defined.
     */
    @JvmName("ghkwonlmuabrxrdc")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value Policy attribute to apply to the policy.
     */
    @JvmName("rttudldfkspjamhf")
    public suspend fun policyAttributes(`value`: List<LoadBalancerPolicyPolicyAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAttributes = mapped
    }

    /**
     * @param argument Policy attribute to apply to the policy.
     */
    @JvmName("gapfkojxqbttqthd")
    public suspend
    fun policyAttributes(argument: List<suspend LoadBalancerPolicyPolicyAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerPolicyPolicyAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyAttributes = mapped
    }

    /**
     * @param argument Policy attribute to apply to the policy.
     */
    @JvmName("tbdbwcmyebjtwffs")
    public suspend fun policyAttributes(
        vararg
        argument: suspend LoadBalancerPolicyPolicyAttributeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerPolicyPolicyAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyAttributes = mapped
    }

    /**
     * @param argument Policy attribute to apply to the policy.
     */
    @JvmName("hkkmvtmmuuhrdouh")
    public suspend
    fun policyAttributes(argument: suspend LoadBalancerPolicyPolicyAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerPolicyPolicyAttributeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyAttributes = mapped
    }

    /**
     * @param values Policy attribute to apply to the policy.
     */
    @JvmName("qyaptsxgdtoexsvc")
    public suspend fun policyAttributes(vararg values: LoadBalancerPolicyPolicyAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyAttributes = mapped
    }

    /**
     * @param value The name of the load balancer policy.
     */
    @JvmName("jefsvpwkshhkcwha")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The policy type.
     */
    @JvmName("ecqajrpydfhmvdmm")
    public suspend fun policyTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyTypeName = mapped
    }

    internal fun build(): LoadBalancerPolicyArgs = LoadBalancerPolicyArgs(
        loadBalancerName = loadBalancerName,
        policyAttributes = policyAttributes,
        policyName = policyName,
        policyTypeName = policyTypeName,
    )
}
