@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.SslNegotiationPolicyArgs.builder
import com.pulumi.aws.elb.kotlin.inputs.SslNegotiationPolicyAttributeArgs
import com.pulumi.aws.elb.kotlin.inputs.SslNegotiationPolicyAttributeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a load balancer SSL negotiation policy, which allows an ELB to control the ciphers and protocols that are supported during SSL negotiations between a client and a load balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.SslNegotiationPolicy;
 * import com.pulumi.aws.elb.SslNegotiationPolicyArgs;
 * import com.pulumi.aws.elb.inputs.SslNegotiationPolicyAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol("https")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::123456789012:server-certificate/certName")
 *                 .build())
 *             .build());
 *         var foo = new SslNegotiationPolicy("foo", SslNegotiationPolicyArgs.builder()
 *             .loadBalancer(lb.id())
 *             .lbPort(443)
 *             .attributes(
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("Protocol-TLSv1")
 *                     .value("false")
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("Protocol-TLSv1.1")
 *                     .value("false")
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("Protocol-TLSv1.2")
 *                     .value("true")
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("Server-Defined-Cipher-Order")
 *                     .value("true")
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("ECDHE-RSA-AES128-GCM-SHA256")
 *                     .value("true")
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("AES128-GCM-SHA256")
 *                     .value("true")
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name("EDH-RSA-DES-CBC3-SHA")
 *                     .value("false")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * @property attributes An SSL Negotiation policy attribute. Each has two properties:
 * @property lbPort The load balancer port to which the policy
 * should be applied. This must be an active listener on the load
 * balancer.
 * @property loadBalancer The load balancer to which the policy
 * should be attached.
 * @property name The name of the attribute
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger a redeployment.
 * To set your attributes, please see the [AWS Elastic Load Balancing Developer Guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-policy-table.html) for a listing of the supported SSL protocols, SSL options, and SSL ciphers.
 * > **NOTE:** The AWS documentation references Server Order Preference, which the AWS Elastic Load Balancing API refers to as `Server-Defined-Cipher-Order`. If you wish to set Server Order Preference, use this value instead.
 */
public data class SslNegotiationPolicyArgs(
    public val attributes: Output<List<SslNegotiationPolicyAttributeArgs>>? = null,
    public val lbPort: Output<Int>? = null,
    public val loadBalancer: Output<String>? = null,
    public val name: Output<String>? = null,
    public val triggers: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.SslNegotiationPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.SslNegotiationPolicyArgs =
        com.pulumi.aws.elb.SslNegotiationPolicyArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lbPort(lbPort?.applyValue({ args0 -> args0 }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SslNegotiationPolicyArgs].
 */
@PulumiTagMarker
public class SslNegotiationPolicyArgsBuilder internal constructor() {
    private var attributes: Output<List<SslNegotiationPolicyAttributeArgs>>? = null

    private var lbPort: Output<Int>? = null

    private var loadBalancer: Output<String>? = null

    private var name: Output<String>? = null

    private var triggers: Output<Map<String, String>>? = null

    /**
     * @param value An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("esgqnsohnwxanbut")
    public suspend fun attributes(`value`: Output<List<SslNegotiationPolicyAttributeArgs>>) {
        this.attributes = value
    }

    @JvmName("aknjyiipkleirwtn")
    public suspend fun attributes(vararg values: Output<SslNegotiationPolicyAttributeArgs>) {
        this.attributes = Output.all(values.asList())
    }

    /**
     * @param values An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("hvvgfdmwcdwppqfu")
    public suspend fun attributes(values: List<Output<SslNegotiationPolicyAttributeArgs>>) {
        this.attributes = Output.all(values)
    }

    /**
     * @param value The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("aaaaialslxomwljt")
    public suspend fun lbPort(`value`: Output<Int>) {
        this.lbPort = value
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("nvmpsnblcwswcrbx")
    public suspend fun loadBalancer(`value`: Output<String>) {
        this.loadBalancer = value
    }

    /**
     * @param value The name of the attribute
     */
    @JvmName("ewnoytghpcelmhtb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     * To set your attributes, please see the [AWS Elastic Load Balancing Developer Guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-policy-table.html) for a listing of the supported SSL protocols, SSL options, and SSL ciphers.
     * > **NOTE:** The AWS documentation references Server Order Preference, which the AWS Elastic Load Balancing API refers to as `Server-Defined-Cipher-Order`. If you wish to set Server Order Preference, use this value instead.
     */
    @JvmName("vatxpthfdcpkwtjg")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("ihmmriddwbathfxn")
    public suspend fun attributes(`value`: List<SslNegotiationPolicyAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("hbciodhixbutwvbk")
    public suspend
    fun attributes(argument: List<suspend SslNegotiationPolicyAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SslNegotiationPolicyAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("waddrokpdriwmuou")
    public suspend fun attributes(
        vararg
        argument: suspend SslNegotiationPolicyAttributeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SslNegotiationPolicyAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("ukqsayekilbmvxhe")
    public suspend
    fun attributes(argument: suspend SslNegotiationPolicyAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SslNegotiationPolicyAttributeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param values An SSL Negotiation policy attribute. Each has two properties:
     */
    @JvmName("uoctcywupfhirffx")
    public suspend fun attributes(vararg values: SslNegotiationPolicyAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("tyovbbfrjbvmnlim")
    public suspend fun lbPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbPort = mapped
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("axeetwjtyxyofyla")
    public suspend fun loadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    /**
     * @param value The name of the attribute
     */
    @JvmName("wifidgrinmofuhos")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     * To set your attributes, please see the [AWS Elastic Load Balancing Developer Guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-policy-table.html) for a listing of the supported SSL protocols, SSL options, and SSL ciphers.
     * > **NOTE:** The AWS documentation references Server Order Preference, which the AWS Elastic Load Balancing API refers to as `Server-Defined-Cipher-Order`. If you wish to set Server Order Preference, use this value instead.
     */
    @JvmName("lrhveviuodmlfoyf")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     * To set your attributes, please see the [AWS Elastic Load Balancing Developer Guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-policy-table.html) for a listing of the supported SSL protocols, SSL options, and SSL ciphers.
     * > **NOTE:** The AWS documentation references Server Order Preference, which the AWS Elastic Load Balancing API refers to as `Server-Defined-Cipher-Order`. If you wish to set Server Order Preference, use this value instead.
     */
    @JvmName("waylqcochdqlpuns")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): SslNegotiationPolicyArgs = SslNegotiationPolicyArgs(
        attributes = attributes,
        lbPort = lbPort,
        loadBalancer = loadBalancer,
        name = name,
        triggers = triggers,
    )
}
