@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.inputs

import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The S3 bucket name to store the logs in.
 * @property bucketPrefix The S3 bucket prefix. Logs are stored in the root if not configured.
 * @property enabled Boolean to enable / disable `access_logs`. Default is `true`
 * @property interval The publishing interval in minutes. Valid values: `5` and `60`. Default: `60`
 */
public data class LoadBalancerAccessLogsArgs(
    public val bucket: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val interval: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs> {
    override fun toJava(): com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs =
        com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerAccessLogsArgs].
 */
@PulumiTagMarker
public class LoadBalancerAccessLogsArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var interval: Output<Int>? = null

    /**
     * @param value The S3 bucket name to store the logs in.
     */
    @JvmName("oplaaceruafhykyo")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The S3 bucket prefix. Logs are stored in the root if not configured.
     */
    @JvmName("vbrikcdtbhvdkuak")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Boolean to enable / disable `access_logs`. Default is `true`
     */
    @JvmName("ldmgfpyvbgvejlhg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The publishing interval in minutes. Valid values: `5` and `60`. Default: `60`
     */
    @JvmName("idlwkuursolpuujh")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The S3 bucket name to store the logs in.
     */
    @JvmName("jruwagcninqxnwyn")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The S3 bucket prefix. Logs are stored in the root if not configured.
     */
    @JvmName("aavbhcglrecntarr")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value Boolean to enable / disable `access_logs`. Default is `true`
     */
    @JvmName("onrbgaembiybqnhc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The publishing interval in minutes. Valid values: `5` and `60`. Default: `60`
     */
    @JvmName("pbevyhuvrysxtwwd")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    internal fun build(): LoadBalancerAccessLogsArgs = LoadBalancerAccessLogsArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        bucketPrefix = bucketPrefix,
        enabled = enabled,
        interval = interval,
    )
}
