@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLoadBalancer.
 * @property accessLogs
 * @property arn
 * @property availabilityZones
 * @property connectionDraining
 * @property connectionDrainingTimeout
 * @property crossZoneLoadBalancing
 * @property desyncMitigationMode
 * @property dnsName
 * @property healthCheck
 * @property id The provider-assigned unique ID for this managed resource.
 * @property idleTimeout
 * @property instances
 * @property internal
 * @property listeners
 * @property name
 * @property securityGroups
 * @property sourceSecurityGroup
 * @property sourceSecurityGroupId
 * @property subnets
 * @property tags
 * @property zoneId
 */
public data class GetLoadBalancerResult(
    public val accessLogs: GetLoadBalancerAccessLogs,
    public val arn: String,
    public val availabilityZones: List<String>,
    public val connectionDraining: Boolean,
    public val connectionDrainingTimeout: Int,
    public val crossZoneLoadBalancing: Boolean,
    public val desyncMitigationMode: String,
    public val dnsName: String,
    public val healthCheck: GetLoadBalancerHealthCheck,
    public val id: String,
    public val idleTimeout: Int,
    public val instances: List<String>,
    public val `internal`: Boolean,
    public val listeners: List<GetLoadBalancerListener>,
    public val name: String,
    public val securityGroups: List<String>,
    public val sourceSecurityGroup: String,
    public val sourceSecurityGroupId: String,
    public val subnets: List<String>,
    public val tags: Map<String, String>,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elb.outputs.GetLoadBalancerResult):
            GetLoadBalancerResult = GetLoadBalancerResult(
            accessLogs = javaType.accessLogs().let({ args0 ->
                com.pulumi.aws.elb.kotlin.outputs.GetLoadBalancerAccessLogs.Companion.toKotlin(args0)
            }),
            arn = javaType.arn(),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            connectionDraining = javaType.connectionDraining(),
            connectionDrainingTimeout = javaType.connectionDrainingTimeout(),
            crossZoneLoadBalancing = javaType.crossZoneLoadBalancing(),
            desyncMitigationMode = javaType.desyncMitigationMode(),
            dnsName = javaType.dnsName(),
            healthCheck = javaType.healthCheck().let({ args0 ->
                com.pulumi.aws.elb.kotlin.outputs.GetLoadBalancerHealthCheck.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            idleTimeout = javaType.idleTimeout(),
            instances = javaType.instances().map({ args0 -> args0 }),
            `internal` = javaType.`internal`(),
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elb.kotlin.outputs.GetLoadBalancerListener.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            sourceSecurityGroup = javaType.sourceSecurityGroup(),
            sourceSecurityGroupId = javaType.sourceSecurityGroupId(),
            subnets = javaType.subnets().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            zoneId = javaType.zoneId(),
        )
    }
}
