@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.kotlin.outputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange
import com.pulumi.aws.emr.kotlin.outputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BlockPublicAccessConfiguration].
 */
@PulumiTagMarker
public class BlockPublicAccessConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlockPublicAccessConfigurationArgs = BlockPublicAccessConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlockPublicAccessConfigurationArgsBuilder.() -> Unit) {
        val builder = BlockPublicAccessConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BlockPublicAccessConfiguration {
        val builtJavaResource =
            com.pulumi.aws.emr.BlockPublicAccessConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BlockPublicAccessConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS EMR block public access configuration. This region level security configuration restricts the launch of EMR clusters that have associated security groups permitting public access on unspecified ports. See the [EMR Block Public Access Configuration](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-block-public-access.html) documentation for further information.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Default Configuration
 * By default, each AWS region is equipped with a block public access configuration that prevents EMR clusters from being launched if they have security group rules permitting public access on any port except for port 22. The default configuration can be managed using this resource.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(true)
 *             .permittedPublicSecurityGroupRuleRanges(BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                 .maxRange(22)
 *                 .minRange(22)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Permitted Public Security Group Rule Ranges
 * The resource permits specification of multiple `permitted_public_security_group_rule_range` blocks.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(true)
 *             .permittedPublicSecurityGroupRuleRanges(
 *                 BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                     .maxRange(22)
 *                     .minRange(22)
 *                     .build(),
 *                 BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                     .maxRange(101)
 *                     .minRange(100)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Disabling Block Public Access
 * To permit EMR clusters to be launched in the configured region regardless of associated security group rules, the Block Public Access feature can be disabled using this resource.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the current EMR Block Public Access Configuration. For example:
 * ```sh
 *  $ pulumi import aws:emr/blockPublicAccessConfiguration:BlockPublicAccessConfiguration example current
 * ```
 *
 */
public class BlockPublicAccessConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.emr.BlockPublicAccessConfiguration,
) : KotlinCustomResource(javaResource, BlockPublicAccessConfigurationMapper) {
    /**
     * Enable or disable EMR Block Public Access.
     * The following arguments are optional:
     */
    public val blockPublicSecurityGroupRules: Output<Boolean>
        get() = javaResource.blockPublicSecurityGroupRules().applyValue({ args0 -> args0 })

    /**
     * Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    public val permittedPublicSecurityGroupRuleRanges:
        Output<List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange>>?
        get() = javaResource.permittedPublicSecurityGroupRuleRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        toKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object BlockPublicAccessConfigurationMapper : ResourceMapper<BlockPublicAccessConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.BlockPublicAccessConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): BlockPublicAccessConfiguration =
        BlockPublicAccessConfiguration(
            javaResource as
                com.pulumi.aws.emr.BlockPublicAccessConfiguration,
        )
}

/**
 * @see [BlockPublicAccessConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlockPublicAccessConfiguration].
 */
public suspend fun blockPublicAccessConfiguration(
    name: String,
    block: suspend BlockPublicAccessConfigurationResourceBuilder.() -> Unit,
):
    BlockPublicAccessConfiguration {
    val builder = BlockPublicAccessConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlockPublicAccessConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blockPublicAccessConfiguration(name: String): BlockPublicAccessConfiguration {
    val builder = BlockPublicAccessConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
