@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs
import com.pulumi.aws.emr.kotlin.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS EMR block public access configuration. This region level security configuration restricts the launch of EMR clusters that have associated security groups permitting public access on unspecified ports. See the [EMR Block Public Access Configuration](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-block-public-access.html) documentation for further information.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Default Configuration
 * By default, each AWS region is equipped with a block public access configuration that prevents EMR clusters from being launched if they have security group rules permitting public access on any port except for port 22. The default configuration can be managed using this resource.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(true)
 *             .permittedPublicSecurityGroupRuleRanges(BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                 .maxRange(22)
 *                 .minRange(22)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Permitted Public Security Group Rule Ranges
 * The resource permits specification of multiple `permitted_public_security_group_rule_range` blocks.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(true)
 *             .permittedPublicSecurityGroupRuleRanges(
 *                 BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                     .maxRange(22)
 *                     .minRange(22)
 *                     .build(),
 *                 BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                     .maxRange(101)
 *                     .minRange(100)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Disabling Block Public Access
 * To permit EMR clusters to be launched in the configured region regardless of associated security group rules, the Block Public Access feature can be disabled using this resource.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration("example", BlockPublicAccessConfigurationArgs.builder()
 *             .blockPublicSecurityGroupRules(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the current EMR Block Public Access Configuration. For example:
 * ```sh
 *  $ pulumi import aws:emr/blockPublicAccessConfiguration:BlockPublicAccessConfiguration example current
 * ```
 * @property blockPublicSecurityGroupRules Enable or disable EMR Block Public Access.
 * The following arguments are optional:
 * @property permittedPublicSecurityGroupRuleRanges Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
 */
public data class BlockPublicAccessConfigurationArgs(
    public val blockPublicSecurityGroupRules: Output<Boolean>? = null,
    public val permittedPublicSecurityGroupRuleRanges:
    Output<List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs =
        com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs.builder()
            .blockPublicSecurityGroupRules(blockPublicSecurityGroupRules?.applyValue({ args0 -> args0 }))
            .permittedPublicSecurityGroupRuleRanges(
                permittedPublicSecurityGroupRuleRanges?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [BlockPublicAccessConfigurationArgs].
 */
@PulumiTagMarker
public class BlockPublicAccessConfigurationArgsBuilder internal constructor() {
    private var blockPublicSecurityGroupRules: Output<Boolean>? = null

    private var permittedPublicSecurityGroupRuleRanges:
        Output<List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs>>? = null

    /**
     * @param value Enable or disable EMR Block Public Access.
     * The following arguments are optional:
     */
    @JvmName("kwsbmcqjxatftuli")
    public suspend fun blockPublicSecurityGroupRules(`value`: Output<Boolean>) {
        this.blockPublicSecurityGroupRules = value
    }

    /**
     * @param value Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("kepifoalexajpqby")
    public suspend
    fun permittedPublicSecurityGroupRuleRanges(`value`: Output<List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs>>) {
        this.permittedPublicSecurityGroupRuleRanges = value
    }

    @JvmName("jwnalulsrpuwqdtd")
    public suspend fun permittedPublicSecurityGroupRuleRanges(
        vararg
        values: Output<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs>,
    ) {
        this.permittedPublicSecurityGroupRuleRanges = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("dyrvjugitjefprsc")
    public suspend
    fun permittedPublicSecurityGroupRuleRanges(values: List<Output<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs>>) {
        this.permittedPublicSecurityGroupRuleRanges = Output.all(values)
    }

    /**
     * @param value Enable or disable EMR Block Public Access.
     * The following arguments are optional:
     */
    @JvmName("fxcxkgqbnclexjgc")
    public suspend fun blockPublicSecurityGroupRules(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicSecurityGroupRules = mapped
    }

    /**
     * @param value Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("vtclqhprlqoekhqv")
    public suspend
    fun permittedPublicSecurityGroupRuleRanges(`value`: List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permittedPublicSecurityGroupRuleRanges = mapped
    }

    /**
     * @param argument Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("luejuupdkjtswbfd")
    public suspend
    fun permittedPublicSecurityGroupRuleRanges(argument: List<suspend BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permittedPublicSecurityGroupRuleRanges = mapped
    }

    /**
     * @param argument Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("wfupbyvhrfxuibel")
    public suspend fun permittedPublicSecurityGroupRuleRanges(
        vararg
        argument: suspend BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permittedPublicSecurityGroupRuleRanges = mapped
    }

    /**
     * @param argument Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("wrxjibtmalqxbpmn")
    public suspend
    fun permittedPublicSecurityGroupRuleRanges(argument: suspend BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.permittedPublicSecurityGroupRuleRanges = mapped
    }

    /**
     * @param values Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     */
    @JvmName("uxkelgwacsukracn")
    public suspend fun permittedPublicSecurityGroupRuleRanges(
        vararg
        values: BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permittedPublicSecurityGroupRuleRanges = mapped
    }

    internal fun build(): BlockPublicAccessConfigurationArgs = BlockPublicAccessConfigurationArgs(
        blockPublicSecurityGroupRules = blockPublicSecurityGroupRules,
        permittedPublicSecurityGroupRuleRanges = permittedPublicSecurityGroupRuleRanges,
    )
}
