@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.kotlin.outputs.ClusterAutoTerminationPolicy
import com.pulumi.aws.emr.kotlin.outputs.ClusterBootstrapAction
import com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceFleet
import com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceGroup
import com.pulumi.aws.emr.kotlin.outputs.ClusterEc2Attributes
import com.pulumi.aws.emr.kotlin.outputs.ClusterKerberosAttributes
import com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceFleet
import com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceGroup
import com.pulumi.aws.emr.kotlin.outputs.ClusterPlacementGroupConfig
import com.pulumi.aws.emr.kotlin.outputs.ClusterStep
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.emr.kotlin.outputs.ClusterAutoTerminationPolicy.Companion.toKotlin as clusterAutoTerminationPolicyToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterBootstrapAction.Companion.toKotlin as clusterBootstrapActionToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceFleet.Companion.toKotlin as clusterCoreInstanceFleetToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceGroup.Companion.toKotlin as clusterCoreInstanceGroupToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterEc2Attributes.Companion.toKotlin as clusterEc2AttributesToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterKerberosAttributes.Companion.toKotlin as clusterKerberosAttributesToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceFleet.Companion.toKotlin as clusterMasterInstanceFleetToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceGroup.Companion.toKotlin as clusterMasterInstanceGroupToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterPlacementGroupConfig.Companion.toKotlin as clusterPlacementGroupConfigToKotlin
import com.pulumi.aws.emr.kotlin.outputs.ClusterStep.Companion.toKotlin as clusterStepToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.emr.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides an Elastic MapReduce Cluster, a web service that makes it easy to process large amounts of data efficiently. See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/elastic-mapreduce/) for more information.
 * To configure [Instance Groups](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for [task nodes](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-task), see the `aws.emr.InstanceGroup` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .releaseLabel("emr-4.6.0")
 *             .applications("Spark")
 *             .additionalInfo("""
 * {
 *   "instanceAwsClientConfiguration": {
 *     "proxyPort": 8099,
 *     "proxyHost": "myproxy.example.com"
 *   }
 * }
 *             """)
 *             .terminationProtection(false)
 *             .keepJobFlowAliveWhenNoSteps(true)
 *             .ec2Attributes(ClusterEc2AttributesArgs.builder()
 *                 .subnetId(aws_subnet.main().id())
 *                 .emrManagedMasterSecurityGroup(aws_security_group.sg().id())
 *                 .emrManagedSlaveSecurityGroup(aws_security_group.sg().id())
 *                 .instanceProfile(aws_iam_instance_profile.emr_profile().arn())
 *                 .build())
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType("m4.large")
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType("c4.large")
 *                 .instanceCount(1)
 *                 .ebsConfigs(ClusterCoreInstanceGroupEbsConfigArgs.builder()
 *                     .size("40")
 *                     .type("gp2")
 *                     .volumesPerInstance(1)
 *                     .build())
 *                 .bidPrice("0.30")
 *                 .autoscalingPolicy("""
 * {
 * "Constraints": {
 *   "MinCapacity": 1,
 *   "MaxCapacity": 2
 * },
 * "Rules": [
 *   {
 *     "Name": "ScaleOutMemoryPercentage",
 *     "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
 *     "Action": {
 *       "SimpleScalingPolicyConfiguration": {
 *         "AdjustmentType": "CHANGE_IN_CAPACITY",
 *         "ScalingAdjustment": 1,
 *         "CoolDown": 300
 *       }
 *     },
 *     "Trigger": {
 *       "CloudWatchAlarmDefinition": {
 *         "ComparisonOperator": "LESS_THAN",
 *         "EvaluationPeriods": 1,
 *         "MetricName": "YARNMemoryAvailablePercentage",
 *         "Namespace": "AWS/ElasticMapReduce",
 *         "Period": 300,
 *         "Statistic": "AVERAGE",
 *         "Threshold": 15.0,
 *         "Unit": "PERCENT"
 *       }
 *     }
 *   }
 * ]
 * }
 *                 """)
 *                 .build())
 *             .ebsRootVolumeSize(100)
 *             .tags(Map.ofEntries(
 *                 Map.entry("role", "rolename"),
 *                 Map.entry("env", "env")
 *             ))
 *             .bootstrapActions(ClusterBootstrapActionArgs.builder()
 *                 .path("s3://elasticmapreduce/bootstrap-actions/run-if")
 *                 .name("runif")
 *                 .args(
 *                     "instance.isMaster=true",
 *                     "echo running on master node")
 *                 .build())
 *             .configurationsJson("""
 *   [
 *     {
 *       "Classification": "hadoop-env",
 *       "Configurations": [
 *         {
 *           "Classification": "export",
 *           "Properties": {
 *             "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 *           }
 *         }
 *       ],
 *       "Properties": {}
 *     },
 *     {
 *       "Classification": "spark-env",
 *       "Configurations": [
 *         {
 *           "Classification": "export",
 *           "Properties": {
 *             "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 *           }
 *         }
 *       ],
 *       "Properties": {}
 *     }
 *   ]
 *             """)
 *             .serviceRole(aws_iam_role.iam_emr_service_role().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Instance Fleet
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsArgs;
 * import com.pulumi.aws.emr.InstanceFleet;
 * import com.pulumi.aws.emr.InstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .masterInstanceFleet(ClusterMasterInstanceFleetArgs.builder()
 *                 .instanceTypeConfigs(ClusterMasterInstanceFleetInstanceTypeConfigArgs.builder()
 *                     .instanceType("m4.xlarge")
 *                     .build())
 *                 .targetOnDemandCapacity(1)
 *                 .build())
 *             .coreInstanceFleet(ClusterCoreInstanceFleetArgs.builder()
 *                 .instanceTypeConfigs(
 *                     ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
 *                         .bidPriceAsPercentageOfOnDemandPrice(80)
 *                         .ebsConfigs(ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                             .size(100)
 *                             .type("gp2")
 *                             .volumesPerInstance(1)
 *                             .build())
 *                         .instanceType("m3.xlarge")
 *                         .weightedCapacity(1)
 *                         .build(),
 *                     ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
 *                         .bidPriceAsPercentageOfOnDemandPrice(100)
 *                         .ebsConfigs(ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                             .size(100)
 *                             .type("gp2")
 *                             .volumesPerInstance(1)
 *                             .build())
 *                         .instanceType("m4.xlarge")
 *                         .weightedCapacity(1)
 *                         .build(),
 *                     ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
 *                         .bidPriceAsPercentageOfOnDemandPrice(100)
 *                         .ebsConfigs(ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                             .size(100)
 *                             .type("gp2")
 *                             .volumesPerInstance(1)
 *                             .build())
 *                         .instanceType("m4.2xlarge")
 *                         .weightedCapacity(2)
 *                         .build())
 *                 .launchSpecifications(ClusterCoreInstanceFleetLaunchSpecificationsArgs.builder()
 *                     .spotSpecifications(ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                         .allocationStrategy("capacity-optimized")
 *                         .blockDurationMinutes(0)
 *                         .timeoutAction("SWITCH_TO_ON_DEMAND")
 *                         .timeoutDurationMinutes(10)
 *                         .build())
 *                     .build())
 *                 .name("core fleet")
 *                 .targetOnDemandCapacity(2)
 *                 .targetSpotCapacity(2)
 *                 .build())
 *             .build());
 *         var task = new InstanceFleet("task", InstanceFleetArgs.builder()
 *             .clusterId(example.id())
 *             .instanceTypeConfigs(
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.xlarge")
 *                     .weightedCapacity(1)
 *                     .build(),
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.2xlarge")
 *                     .weightedCapacity(2)
 *                     .build())
 *             .launchSpecifications(InstanceFleetLaunchSpecificationsArgs.builder()
 *                 .spotSpecifications(InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                     .allocationStrategy("capacity-optimized")
 *                     .blockDurationMinutes(0)
 *                     .timeoutAction("TERMINATE_CLUSTER")
 *                     .timeoutDurationMinutes(10)
 *                     .build())
 *                 .build())
 *             .targetOnDemandCapacity(1)
 *             .targetSpotCapacity(1)
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Debug Logging
 * [Debug logging in EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-debugging.html) is implemented as a step. It is highly recommended that you utilize the resource options configuration with `ignoreChanges` if other steps are being managed outside of this provider.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterStepArgs;
 * import com.pulumi.aws.emr.inputs.ClusterStepHadoopJarStepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .steps(ClusterStepArgs.builder()
 *                 .actionOnFailure("TERMINATE_CLUSTER")
 *                 .name("Setup Hadoop Debugging")
 *                 .hadoopJarStep(ClusterStepHadoopJarStepArgs.builder()
 *                     .jar("command-runner.jar")
 *                     .args("state-pusher-script")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Node Master Instance Group
 * Available in EMR version 5.23.0 and later, an EMR Cluster can be launched with three master nodes for high availability. Additional information about this functionality and its requirements can be found in the [EMR Management Guide](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-ha.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSubnet = new Subnet("exampleSubnet", SubnetArgs.builder()
 *             .mapPublicIpOnLaunch(true)
 *             .build());
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .releaseLabel("emr-5.24.1")
 *             .terminationProtection(true)
 *             .ec2Attributes(ClusterEc2AttributesArgs.builder()
 *                 .subnetId(exampleSubnet.id())
 *                 .build())
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceCount(3)
 *                 .build())
 *             .coreInstanceGroup()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR clusters using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:emr/cluster:Cluster cluster j-123456ABCDEF
 * ```
 *  Since the API does not return the actual values for Kerberos configurations, environments with those options set will need to use the `lifecycle` configuration block `ignore_changes` argument available to all Pulumi resources to prevent perpetual differences. For example:
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.emr.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
     */
    public val additionalInfo: Output<String>?
        get() = javaResource.additionalInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     */
    public val applications: Output<List<String>>?
        get() = javaResource.applications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * ARN of the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
     */
    public val autoTerminationPolicy: Output<ClusterAutoTerminationPolicy>?
        get() = javaResource.autoTerminationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterAutoTerminationPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     */
    public val autoscalingRole: Output<String>?
        get() = javaResource.autoscalingRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    public val bootstrapActions: Output<List<ClusterBootstrapAction>>?
        get() = javaResource.bootstrapActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        clusterBootstrapActionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val clusterState: Output<String>
        get() = javaResource.clusterState().applyValue({ args0 -> args0 })

    /**
     * List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
     */
    public val configurations: Output<String>?
        get() = javaResource.configurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON string for supplying list of configurations for the EMR cluster.
     * > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const cluster = new aws.emr.Cluster("cluster", {configurationsJson: `[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * cluster = aws.emr.Cluster("cluster", configurations_json="""[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * """)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var cluster = new Aws.Emr.Cluster("cluster", new()
     *     {
     *         ConfigurationsJson = @"[
     * {
     * ""Classification"": ""hadoop-env"",
     * ""Configurations"": [
     * {
     * ""Classification"": ""export"",
     * ""Properties"": {
     * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
     * }
     * }
     * ],
     * ""Properties"": {}
     * }
     * ]
     * ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.NewCluster(ctx, "cluster", &emr.ClusterArgs{
     * 			ConfigurationsJson: pulumi.String(`[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.Cluster;
     * import com.pulumi.aws.emr.ClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .configurationsJson("""
     * [
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   cluster:
     *     type: aws:emr:Cluster
     *     properties:
     *       configurationsJson: |+
     *         [
     *         {
     *         "Classification": "hadoop-env",
     *         "Configurations": [
     *         {
     *         "Classification": "export",
     *         "Properties": {
     *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     *         }
     *         }
     *         ],
     *         "Properties": {}
     *         }
     *         ]
     * ```
     */
    public val configurationsJson: Output<String>?
        get() = javaResource.configurationsJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
     */
    public val coreInstanceFleet: Output<ClusterCoreInstanceFleet>
        get() = javaResource.coreInstanceFleet().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterCoreInstanceFleetToKotlin(args0)
            })
        })

    /**
     * Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
     */
    public val coreInstanceGroup: Output<ClusterCoreInstanceGroup>
        get() = javaResource.coreInstanceGroup().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterCoreInstanceGroupToKotlin(args0)
            })
        })

    /**
     * Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
     */
    public val customAmiId: Output<String>?
        get() = javaResource.customAmiId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
     */
    public val ebsRootVolumeSize: Output<Int>?
        get() = javaResource.ebsRootVolumeSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Attributes for the EC2 instances running the job flow. See below.
     */
    public val ec2Attributes: Output<ClusterEc2Attributes>?
        get() = javaResource.ec2Attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterEc2AttributesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Switch on/off run cluster with no steps or when all steps are complete (default is on)
     */
    public val keepJobFlowAliveWhenNoSteps: Output<Boolean>
        get() = javaResource.keepJobFlowAliveWhenNoSteps().applyValue({ args0 -> args0 })

    /**
     * Kerberos configuration for the cluster. See below.
     */
    public val kerberosAttributes: Output<ClusterKerberosAttributes>?
        get() = javaResource.kerberosAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterKerberosAttributesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     */
    public val listStepsStates: Output<List<String>>?
        get() = javaResource.listStepsStates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    public val logEncryptionKmsKeyId: Output<String>?
        get() = javaResource.logEncryptionKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
     */
    public val logUri: Output<String>?
        get() = javaResource.logUri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
     */
    public val masterInstanceFleet: Output<ClusterMasterInstanceFleet>
        get() = javaResource.masterInstanceFleet().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterMasterInstanceFleetToKotlin(args0)
            })
        })

    /**
     * Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
     */
    public val masterInstanceGroup: Output<ClusterMasterInstanceGroup>
        get() = javaResource.masterInstanceGroup().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterMasterInstanceGroupToKotlin(args0)
            })
        })

    /**
     * The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
     */
    public val masterPublicDns: Output<String>
        get() = javaResource.masterPublicDns().applyValue({ args0 -> args0 })

    /**
     * Name of the job flow.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The specified placement group configuration for an Amazon EMR cluster.
     */
    public val placementGroupConfigs: Output<List<ClusterPlacementGroupConfig>>?
        get() = javaResource.placementGroupConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        clusterPlacementGroupConfigToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Release label for the Amazon EMR release.
     */
    public val releaseLabel: Output<String>
        get() = javaResource.releaseLabel().applyValue({ args0 -> args0 })

    /**
     * Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
     */
    public val scaleDownBehavior: Output<String>
        get() = javaResource.scaleDownBehavior().applyValue({ args0 -> args0 })

    /**
     * Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
     */
    public val securityConfiguration: Output<String>?
        get() = javaResource.securityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IAM role that will be assumed by the Amazon EMR service to access AWS resources.
     * The following arguments are optional:
     */
    public val serviceRole: Output<String>
        get() = javaResource.serviceRole().applyValue({ args0 -> args0 })

    /**
     * Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
     */
    public val stepConcurrencyLevel: Output<Int>?
        get() = javaResource.stepConcurrencyLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    public val steps: Output<List<ClusterStep>>
        get() = javaResource.steps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterStepToKotlin(args0)
                })
            })
        })

    /**
     * list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
     */
    public val terminationProtection: Output<Boolean>
        get() = javaResource.terminationProtection().applyValue({ args0 -> args0 })

    /**
     * Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
     */
    public val visibleToAllUsers: Output<Boolean>?
        get() = javaResource.visibleToAllUsers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.emr.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
