@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.ClusterArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.ClusterAutoTerminationPolicyArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterAutoTerminationPolicyArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterBootstrapActionArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterBootstrapActionArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterCoreInstanceFleetArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterCoreInstanceFleetArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterCoreInstanceGroupArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterCoreInstanceGroupArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterEc2AttributesArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterEc2AttributesArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterKerberosAttributesArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterKerberosAttributesArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterMasterInstanceFleetArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterMasterInstanceFleetArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterMasterInstanceGroupArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterMasterInstanceGroupArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterPlacementGroupConfigArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterPlacementGroupConfigArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.ClusterStepArgs
import com.pulumi.aws.emr.kotlin.inputs.ClusterStepArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Cluster, a web service that makes it easy to process large amounts of data efficiently. See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/elastic-mapreduce/) for more information.
 * To configure [Instance Groups](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for [task nodes](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-task), see the `aws.emr.InstanceGroup` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .releaseLabel("emr-4.6.0")
 *             .applications("Spark")
 *             .additionalInfo("""
 * {
 *   "instanceAwsClientConfiguration": {
 *     "proxyPort": 8099,
 *     "proxyHost": "myproxy.example.com"
 *   }
 * }
 *             """)
 *             .terminationProtection(false)
 *             .keepJobFlowAliveWhenNoSteps(true)
 *             .ec2Attributes(ClusterEc2AttributesArgs.builder()
 *                 .subnetId(aws_subnet.main().id())
 *                 .emrManagedMasterSecurityGroup(aws_security_group.sg().id())
 *                 .emrManagedSlaveSecurityGroup(aws_security_group.sg().id())
 *                 .instanceProfile(aws_iam_instance_profile.emr_profile().arn())
 *                 .build())
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType("m4.large")
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType("c4.large")
 *                 .instanceCount(1)
 *                 .ebsConfigs(ClusterCoreInstanceGroupEbsConfigArgs.builder()
 *                     .size("40")
 *                     .type("gp2")
 *                     .volumesPerInstance(1)
 *                     .build())
 *                 .bidPrice("0.30")
 *                 .autoscalingPolicy("""
 * {
 * "Constraints": {
 *   "MinCapacity": 1,
 *   "MaxCapacity": 2
 * },
 * "Rules": [
 *   {
 *     "Name": "ScaleOutMemoryPercentage",
 *     "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
 *     "Action": {
 *       "SimpleScalingPolicyConfiguration": {
 *         "AdjustmentType": "CHANGE_IN_CAPACITY",
 *         "ScalingAdjustment": 1,
 *         "CoolDown": 300
 *       }
 *     },
 *     "Trigger": {
 *       "CloudWatchAlarmDefinition": {
 *         "ComparisonOperator": "LESS_THAN",
 *         "EvaluationPeriods": 1,
 *         "MetricName": "YARNMemoryAvailablePercentage",
 *         "Namespace": "AWS/ElasticMapReduce",
 *         "Period": 300,
 *         "Statistic": "AVERAGE",
 *         "Threshold": 15.0,
 *         "Unit": "PERCENT"
 *       }
 *     }
 *   }
 * ]
 * }
 *                 """)
 *                 .build())
 *             .ebsRootVolumeSize(100)
 *             .tags(Map.ofEntries(
 *                 Map.entry("role", "rolename"),
 *                 Map.entry("env", "env")
 *             ))
 *             .bootstrapActions(ClusterBootstrapActionArgs.builder()
 *                 .path("s3://elasticmapreduce/bootstrap-actions/run-if")
 *                 .name("runif")
 *                 .args(
 *                     "instance.isMaster=true",
 *                     "echo running on master node")
 *                 .build())
 *             .configurationsJson("""
 *   [
 *     {
 *       "Classification": "hadoop-env",
 *       "Configurations": [
 *         {
 *           "Classification": "export",
 *           "Properties": {
 *             "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 *           }
 *         }
 *       ],
 *       "Properties": {}
 *     },
 *     {
 *       "Classification": "spark-env",
 *       "Configurations": [
 *         {
 *           "Classification": "export",
 *           "Properties": {
 *             "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 *           }
 *         }
 *       ],
 *       "Properties": {}
 *     }
 *   ]
 *             """)
 *             .serviceRole(aws_iam_role.iam_emr_service_role().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Instance Fleet
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsArgs;
 * import com.pulumi.aws.emr.InstanceFleet;
 * import com.pulumi.aws.emr.InstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .masterInstanceFleet(ClusterMasterInstanceFleetArgs.builder()
 *                 .instanceTypeConfigs(ClusterMasterInstanceFleetInstanceTypeConfigArgs.builder()
 *                     .instanceType("m4.xlarge")
 *                     .build())
 *                 .targetOnDemandCapacity(1)
 *                 .build())
 *             .coreInstanceFleet(ClusterCoreInstanceFleetArgs.builder()
 *                 .instanceTypeConfigs(
 *                     ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
 *                         .bidPriceAsPercentageOfOnDemandPrice(80)
 *                         .ebsConfigs(ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                             .size(100)
 *                             .type("gp2")
 *                             .volumesPerInstance(1)
 *                             .build())
 *                         .instanceType("m3.xlarge")
 *                         .weightedCapacity(1)
 *                         .build(),
 *                     ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
 *                         .bidPriceAsPercentageOfOnDemandPrice(100)
 *                         .ebsConfigs(ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                             .size(100)
 *                             .type("gp2")
 *                             .volumesPerInstance(1)
 *                             .build())
 *                         .instanceType("m4.xlarge")
 *                         .weightedCapacity(1)
 *                         .build(),
 *                     ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
 *                         .bidPriceAsPercentageOfOnDemandPrice(100)
 *                         .ebsConfigs(ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                             .size(100)
 *                             .type("gp2")
 *                             .volumesPerInstance(1)
 *                             .build())
 *                         .instanceType("m4.2xlarge")
 *                         .weightedCapacity(2)
 *                         .build())
 *                 .launchSpecifications(ClusterCoreInstanceFleetLaunchSpecificationsArgs.builder()
 *                     .spotSpecifications(ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                         .allocationStrategy("capacity-optimized")
 *                         .blockDurationMinutes(0)
 *                         .timeoutAction("SWITCH_TO_ON_DEMAND")
 *                         .timeoutDurationMinutes(10)
 *                         .build())
 *                     .build())
 *                 .name("core fleet")
 *                 .targetOnDemandCapacity(2)
 *                 .targetSpotCapacity(2)
 *                 .build())
 *             .build());
 *         var task = new InstanceFleet("task", InstanceFleetArgs.builder()
 *             .clusterId(example.id())
 *             .instanceTypeConfigs(
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.xlarge")
 *                     .weightedCapacity(1)
 *                     .build(),
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.2xlarge")
 *                     .weightedCapacity(2)
 *                     .build())
 *             .launchSpecifications(InstanceFleetLaunchSpecificationsArgs.builder()
 *                 .spotSpecifications(InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                     .allocationStrategy("capacity-optimized")
 *                     .blockDurationMinutes(0)
 *                     .timeoutAction("TERMINATE_CLUSTER")
 *                     .timeoutDurationMinutes(10)
 *                     .build())
 *                 .build())
 *             .targetOnDemandCapacity(1)
 *             .targetSpotCapacity(1)
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Debug Logging
 * [Debug logging in EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-debugging.html) is implemented as a step. It is highly recommended that you utilize the resource options configuration with `ignoreChanges` if other steps are being managed outside of this provider.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterStepArgs;
 * import com.pulumi.aws.emr.inputs.ClusterStepHadoopJarStepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .steps(ClusterStepArgs.builder()
 *                 .actionOnFailure("TERMINATE_CLUSTER")
 *                 .name("Setup Hadoop Debugging")
 *                 .hadoopJarStep(ClusterStepHadoopJarStepArgs.builder()
 *                     .jar("command-runner.jar")
 *                     .args("state-pusher-script")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Node Master Instance Group
 * Available in EMR version 5.23.0 and later, an EMR Cluster can be launched with three master nodes for high availability. Additional information about this functionality and its requirements can be found in the [EMR Management Guide](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-ha.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSubnet = new Subnet("exampleSubnet", SubnetArgs.builder()
 *             .mapPublicIpOnLaunch(true)
 *             .build());
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .releaseLabel("emr-5.24.1")
 *             .terminationProtection(true)
 *             .ec2Attributes(ClusterEc2AttributesArgs.builder()
 *                 .subnetId(exampleSubnet.id())
 *                 .build())
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceCount(3)
 *                 .build())
 *             .coreInstanceGroup()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR clusters using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:emr/cluster:Cluster cluster j-123456ABCDEF
 * ```
 *  Since the API does not return the actual values for Kerberos configurations, environments with those options set will need to use the `lifecycle` configuration block `ignore_changes` argument available to all Pulumi resources to prevent perpetual differences. For example:
 * @property additionalInfo JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
 * @property applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
 * @property autoTerminationPolicy An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
 * @property autoscalingRole IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
 * @property bootstrapActions Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
 * @property configurations List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
 * @property configurationsJson JSON string for supplying list of configurations for the EMR cluster.
 * > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cluster = new aws.emr.Cluster("cluster", {configurationsJson: `[
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 * `});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cluster = aws.emr.Cluster("cluster", configurations_json="""[
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new Aws.Emr.Cluster("cluster", new()
 *     {
 *         ConfigurationsJson = @"[
 * {
 * ""Classification"": ""hadoop-env"",
 * ""Configurations"": [
 * {
 * ""Classification"": ""export"",
 * ""Properties"": {
 * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
 * }
 * }
 * ],
 * ""Properties"": {}
 * }
 * ]
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewCluster(ctx, "cluster", &emr.ClusterArgs{
 * 			ConfigurationsJson: pulumi.String(`[
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .configurationsJson("""
 * [
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cluster:
 *     type: aws:emr:Cluster
 *     properties:
 *       configurationsJson: |+
 *         [
 *         {
 *         "Classification": "hadoop-env",
 *         "Configurations": [
 *         {
 *         "Classification": "export",
 *         "Properties": {
 *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 *         }
 *         }
 *         ],
 *         "Properties": {}
 *         }
 *         ]
 * ```
 * @property coreInstanceFleet Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
 * @property coreInstanceGroup Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
 * @property customAmiId Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
 * @property ebsRootVolumeSize Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
 * @property ec2Attributes Attributes for the EC2 instances running the job flow. See below.
 * @property keepJobFlowAliveWhenNoSteps Switch on/off run cluster with no steps or when all steps are complete (default is on)
 * @property kerberosAttributes Kerberos configuration for the cluster. See below.
 * @property listStepsStates List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
 * @property logEncryptionKmsKeyId AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
 * @property logUri S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
 * @property masterInstanceFleet Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
 * @property masterInstanceGroup Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
 * @property name Name of the job flow.
 * @property placementGroupConfigs The specified placement group configuration for an Amazon EMR cluster.
 * @property releaseLabel Release label for the Amazon EMR release.
 * @property scaleDownBehavior Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
 * @property securityConfiguration Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
 * @property serviceRole IAM role that will be assumed by the Amazon EMR service to access AWS resources.
 * The following arguments are optional:
 * @property stepConcurrencyLevel Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
 * @property steps List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
 * @property tags list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property terminationProtection Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
 * @property visibleToAllUsers Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
 */
public data class ClusterArgs(
    public val additionalInfo: Output<String>? = null,
    public val applications: Output<List<String>>? = null,
    public val autoTerminationPolicy: Output<ClusterAutoTerminationPolicyArgs>? = null,
    public val autoscalingRole: Output<String>? = null,
    public val bootstrapActions: Output<List<ClusterBootstrapActionArgs>>? = null,
    public val configurations: Output<String>? = null,
    public val configurationsJson: Output<String>? = null,
    public val coreInstanceFleet: Output<ClusterCoreInstanceFleetArgs>? = null,
    public val coreInstanceGroup: Output<ClusterCoreInstanceGroupArgs>? = null,
    public val customAmiId: Output<String>? = null,
    public val ebsRootVolumeSize: Output<Int>? = null,
    public val ec2Attributes: Output<ClusterEc2AttributesArgs>? = null,
    public val keepJobFlowAliveWhenNoSteps: Output<Boolean>? = null,
    public val kerberosAttributes: Output<ClusterKerberosAttributesArgs>? = null,
    public val listStepsStates: Output<List<String>>? = null,
    public val logEncryptionKmsKeyId: Output<String>? = null,
    public val logUri: Output<String>? = null,
    public val masterInstanceFleet: Output<ClusterMasterInstanceFleetArgs>? = null,
    public val masterInstanceGroup: Output<ClusterMasterInstanceGroupArgs>? = null,
    public val name: Output<String>? = null,
    public val placementGroupConfigs: Output<List<ClusterPlacementGroupConfigArgs>>? = null,
    public val releaseLabel: Output<String>? = null,
    public val scaleDownBehavior: Output<String>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val serviceRole: Output<String>? = null,
    public val stepConcurrencyLevel: Output<Int>? = null,
    public val steps: Output<List<ClusterStepArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminationProtection: Output<Boolean>? = null,
    public val visibleToAllUsers: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.emr.ClusterArgs = com.pulumi.aws.emr.ClusterArgs.builder()
        .additionalInfo(additionalInfo?.applyValue({ args0 -> args0 }))
        .applications(applications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .autoTerminationPolicy(
            autoTerminationPolicy?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .autoscalingRole(autoscalingRole?.applyValue({ args0 -> args0 }))
        .bootstrapActions(
            bootstrapActions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .configurations(configurations?.applyValue({ args0 -> args0 }))
        .configurationsJson(configurationsJson?.applyValue({ args0 -> args0 }))
        .coreInstanceFleet(coreInstanceFleet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .coreInstanceGroup(coreInstanceGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .customAmiId(customAmiId?.applyValue({ args0 -> args0 }))
        .ebsRootVolumeSize(ebsRootVolumeSize?.applyValue({ args0 -> args0 }))
        .ec2Attributes(ec2Attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .keepJobFlowAliveWhenNoSteps(keepJobFlowAliveWhenNoSteps?.applyValue({ args0 -> args0 }))
        .kerberosAttributes(
            kerberosAttributes?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .listStepsStates(listStepsStates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .logEncryptionKmsKeyId(logEncryptionKmsKeyId?.applyValue({ args0 -> args0 }))
        .logUri(logUri?.applyValue({ args0 -> args0 }))
        .masterInstanceFleet(
            masterInstanceFleet?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .masterInstanceGroup(
            masterInstanceGroup?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .placementGroupConfigs(
            placementGroupConfigs?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .releaseLabel(releaseLabel?.applyValue({ args0 -> args0 }))
        .scaleDownBehavior(scaleDownBehavior?.applyValue({ args0 -> args0 }))
        .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
        .serviceRole(serviceRole?.applyValue({ args0 -> args0 }))
        .stepConcurrencyLevel(stepConcurrencyLevel?.applyValue({ args0 -> args0 }))
        .steps(steps?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .terminationProtection(terminationProtection?.applyValue({ args0 -> args0 }))
        .visibleToAllUsers(visibleToAllUsers?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var additionalInfo: Output<String>? = null

    private var applications: Output<List<String>>? = null

    private var autoTerminationPolicy: Output<ClusterAutoTerminationPolicyArgs>? = null

    private var autoscalingRole: Output<String>? = null

    private var bootstrapActions: Output<List<ClusterBootstrapActionArgs>>? = null

    private var configurations: Output<String>? = null

    private var configurationsJson: Output<String>? = null

    private var coreInstanceFleet: Output<ClusterCoreInstanceFleetArgs>? = null

    private var coreInstanceGroup: Output<ClusterCoreInstanceGroupArgs>? = null

    private var customAmiId: Output<String>? = null

    private var ebsRootVolumeSize: Output<Int>? = null

    private var ec2Attributes: Output<ClusterEc2AttributesArgs>? = null

    private var keepJobFlowAliveWhenNoSteps: Output<Boolean>? = null

    private var kerberosAttributes: Output<ClusterKerberosAttributesArgs>? = null

    private var listStepsStates: Output<List<String>>? = null

    private var logEncryptionKmsKeyId: Output<String>? = null

    private var logUri: Output<String>? = null

    private var masterInstanceFleet: Output<ClusterMasterInstanceFleetArgs>? = null

    private var masterInstanceGroup: Output<ClusterMasterInstanceGroupArgs>? = null

    private var name: Output<String>? = null

    private var placementGroupConfigs: Output<List<ClusterPlacementGroupConfigArgs>>? = null

    private var releaseLabel: Output<String>? = null

    private var scaleDownBehavior: Output<String>? = null

    private var securityConfiguration: Output<String>? = null

    private var serviceRole: Output<String>? = null

    private var stepConcurrencyLevel: Output<Int>? = null

    private var steps: Output<List<ClusterStepArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminationProtection: Output<Boolean>? = null

    private var visibleToAllUsers: Output<Boolean>? = null

    /**
     * @param value JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
     */
    @JvmName("rtnkqdiubycifmfu")
    public suspend fun additionalInfo(`value`: Output<String>) {
        this.additionalInfo = value
    }

    /**
     * @param value A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     */
    @JvmName("hbetdrkhcydbhhyr")
    public suspend fun applications(`value`: Output<List<String>>) {
        this.applications = value
    }

    @JvmName("oipynvtpvprplwgn")
    public suspend fun applications(vararg values: Output<String>) {
        this.applications = Output.all(values.asList())
    }

    /**
     * @param values A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     */
    @JvmName("tqmmfleprpvcnceu")
    public suspend fun applications(values: List<Output<String>>) {
        this.applications = Output.all(values)
    }

    /**
     * @param value An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
     */
    @JvmName("isflhoyvouholvoy")
    public suspend fun autoTerminationPolicy(`value`: Output<ClusterAutoTerminationPolicyArgs>) {
        this.autoTerminationPolicy = value
    }

    /**
     * @param value IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     */
    @JvmName("jmorvvwnuupkgkxt")
    public suspend fun autoscalingRole(`value`: Output<String>) {
        this.autoscalingRole = value
    }

    /**
     * @param value Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("uqixxalicnlrckrq")
    public suspend fun bootstrapActions(`value`: Output<List<ClusterBootstrapActionArgs>>) {
        this.bootstrapActions = value
    }

    @JvmName("lyphrwifijjcnjsa")
    public suspend fun bootstrapActions(vararg values: Output<ClusterBootstrapActionArgs>) {
        this.bootstrapActions = Output.all(values.asList())
    }

    /**
     * @param values Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("ljyltmsnjkyhftrs")
    public suspend fun bootstrapActions(values: List<Output<ClusterBootstrapActionArgs>>) {
        this.bootstrapActions = Output.all(values)
    }

    /**
     * @param value List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
     */
    @JvmName("sqbjobakxiovydry")
    public suspend fun configurations(`value`: Output<String>) {
        this.configurations = value
    }

    /**
     * @param value JSON string for supplying list of configurations for the EMR cluster.
     * > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const cluster = new aws.emr.Cluster("cluster", {configurationsJson: `[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * cluster = aws.emr.Cluster("cluster", configurations_json="""[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * """)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var cluster = new Aws.Emr.Cluster("cluster", new()
     *     {
     *         ConfigurationsJson = @"[
     * {
     * ""Classification"": ""hadoop-env"",
     * ""Configurations"": [
     * {
     * ""Classification"": ""export"",
     * ""Properties"": {
     * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
     * }
     * }
     * ],
     * ""Properties"": {}
     * }
     * ]
     * ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.NewCluster(ctx, "cluster", &emr.ClusterArgs{
     * 			ConfigurationsJson: pulumi.String(`[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.Cluster;
     * import com.pulumi.aws.emr.ClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .configurationsJson("""
     * [
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   cluster:
     *     type: aws:emr:Cluster
     *     properties:
     *       configurationsJson: |+
     *         [
     *         {
     *         "Classification": "hadoop-env",
     *         "Configurations": [
     *         {
     *         "Classification": "export",
     *         "Properties": {
     *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     *         }
     *         }
     *         ],
     *         "Properties": {}
     *         }
     *         ]
     * ```
     */
    @JvmName("pjtlkwknukijrhnc")
    public suspend fun configurationsJson(`value`: Output<String>) {
        this.configurationsJson = value
    }

    /**
     * @param value Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
     */
    @JvmName("ijhacjywcwvsxorv")
    public suspend fun coreInstanceFleet(`value`: Output<ClusterCoreInstanceFleetArgs>) {
        this.coreInstanceFleet = value
    }

    /**
     * @param value Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
     */
    @JvmName("gsreqjpbfsusidin")
    public suspend fun coreInstanceGroup(`value`: Output<ClusterCoreInstanceGroupArgs>) {
        this.coreInstanceGroup = value
    }

    /**
     * @param value Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
     */
    @JvmName("jppugmnvnggdivqu")
    public suspend fun customAmiId(`value`: Output<String>) {
        this.customAmiId = value
    }

    /**
     * @param value Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
     */
    @JvmName("htrakcfasrtxwtmw")
    public suspend fun ebsRootVolumeSize(`value`: Output<Int>) {
        this.ebsRootVolumeSize = value
    }

    /**
     * @param value Attributes for the EC2 instances running the job flow. See below.
     */
    @JvmName("yyhljmhkxqmvykmm")
    public suspend fun ec2Attributes(`value`: Output<ClusterEc2AttributesArgs>) {
        this.ec2Attributes = value
    }

    /**
     * @param value Switch on/off run cluster with no steps or when all steps are complete (default is on)
     */
    @JvmName("jefcdsfiogvvnjxi")
    public suspend fun keepJobFlowAliveWhenNoSteps(`value`: Output<Boolean>) {
        this.keepJobFlowAliveWhenNoSteps = value
    }

    /**
     * @param value Kerberos configuration for the cluster. See below.
     */
    @JvmName("gfiwwihgkrkhpuxh")
    public suspend fun kerberosAttributes(`value`: Output<ClusterKerberosAttributesArgs>) {
        this.kerberosAttributes = value
    }

    /**
     * @param value List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     */
    @JvmName("hcwagirajjwmwmhm")
    public suspend fun listStepsStates(`value`: Output<List<String>>) {
        this.listStepsStates = value
    }

    @JvmName("cnhhbjsfucbevcot")
    public suspend fun listStepsStates(vararg values: Output<String>) {
        this.listStepsStates = Output.all(values.asList())
    }

    /**
     * @param values List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     */
    @JvmName("qpanpjlqqfravfaf")
    public suspend fun listStepsStates(values: List<Output<String>>) {
        this.listStepsStates = Output.all(values)
    }

    /**
     * @param value AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    @JvmName("tcbvjgggkmngpcls")
    public suspend fun logEncryptionKmsKeyId(`value`: Output<String>) {
        this.logEncryptionKmsKeyId = value
    }

    /**
     * @param value S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
     */
    @JvmName("ylxyjauixhkhatit")
    public suspend fun logUri(`value`: Output<String>) {
        this.logUri = value
    }

    /**
     * @param value Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
     */
    @JvmName("prkvtxvwmhdtgqxp")
    public suspend fun masterInstanceFleet(`value`: Output<ClusterMasterInstanceFleetArgs>) {
        this.masterInstanceFleet = value
    }

    /**
     * @param value Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
     */
    @JvmName("qffyajaibikapplu")
    public suspend fun masterInstanceGroup(`value`: Output<ClusterMasterInstanceGroupArgs>) {
        this.masterInstanceGroup = value
    }

    /**
     * @param value Name of the job flow.
     */
    @JvmName("gujwsmkcwddbbcsw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("lfeaxuwltxdlydrj")
    public suspend fun placementGroupConfigs(`value`: Output<List<ClusterPlacementGroupConfigArgs>>) {
        this.placementGroupConfigs = value
    }

    @JvmName("esicewgecsiganbx")
    public suspend fun placementGroupConfigs(vararg values: Output<ClusterPlacementGroupConfigArgs>) {
        this.placementGroupConfigs = Output.all(values.asList())
    }

    /**
     * @param values The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("njmmtohmrhpvsoas")
    public suspend fun placementGroupConfigs(values: List<Output<ClusterPlacementGroupConfigArgs>>) {
        this.placementGroupConfigs = Output.all(values)
    }

    /**
     * @param value Release label for the Amazon EMR release.
     */
    @JvmName("ifpydpctjabanktx")
    public suspend fun releaseLabel(`value`: Output<String>) {
        this.releaseLabel = value
    }

    /**
     * @param value Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
     */
    @JvmName("pemvahunhllurbup")
    public suspend fun scaleDownBehavior(`value`: Output<String>) {
        this.scaleDownBehavior = value
    }

    /**
     * @param value Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
     */
    @JvmName("xcptorbpraxtmxms")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value IAM role that will be assumed by the Amazon EMR service to access AWS resources.
     * The following arguments are optional:
     */
    @JvmName("tuyeywgpjjvouiak")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
     */
    @JvmName("viiehxbogdybtwct")
    public suspend fun stepConcurrencyLevel(`value`: Output<Int>) {
        this.stepConcurrencyLevel = value
    }

    /**
     * @param value List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("vojdkmlsscceeyyi")
    public suspend fun steps(`value`: Output<List<ClusterStepArgs>>) {
        this.steps = value
    }

    @JvmName("mbpvncqmjjiojofa")
    public suspend fun steps(vararg values: Output<ClusterStepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("hulpjedxeujjhbfh")
    public suspend fun steps(values: List<Output<ClusterStepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bjprnlqsnowvrjqr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
     */
    @JvmName("thmddmytdaescpqb")
    public suspend fun terminationProtection(`value`: Output<Boolean>) {
        this.terminationProtection = value
    }

    /**
     * @param value Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
     */
    @JvmName("ekigihjmgngqgoxs")
    public suspend fun visibleToAllUsers(`value`: Output<Boolean>) {
        this.visibleToAllUsers = value
    }

    /**
     * @param value JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
     */
    @JvmName("pjjgdmikltediipt")
    public suspend fun additionalInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalInfo = mapped
    }

    /**
     * @param value A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     */
    @JvmName("bfqjmhtdhuyqbcuu")
    public suspend fun applications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param values A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     */
    @JvmName("cibixrnyusvlwjuu")
    public suspend fun applications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param value An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
     */
    @JvmName("tteaciposueodecn")
    public suspend fun autoTerminationPolicy(`value`: ClusterAutoTerminationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoTerminationPolicy = mapped
    }

    /**
     * @param argument An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
     */
    @JvmName("abpqjkxmmgapvfuw")
    public suspend
    fun autoTerminationPolicy(argument: suspend ClusterAutoTerminationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterAutoTerminationPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoTerminationPolicy = mapped
    }

    /**
     * @param value IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     */
    @JvmName("arlqpebfrfnxpusf")
    public suspend fun autoscalingRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingRole = mapped
    }

    /**
     * @param value Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("muinxmrnthhupnvs")
    public suspend fun bootstrapActions(`value`: List<ClusterBootstrapActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootstrapActions = mapped
    }

    /**
     * @param argument Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("gvqlfrpfovegfdhj")
    public suspend
    fun bootstrapActions(argument: List<suspend ClusterBootstrapActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterBootstrapActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bootstrapActions = mapped
    }

    /**
     * @param argument Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("dvlnugyxgacsimbe")
    public suspend fun bootstrapActions(
        vararg
        argument: suspend ClusterBootstrapActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterBootstrapActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bootstrapActions = mapped
    }

    /**
     * @param argument Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("rcxfgynstfnctskb")
    public suspend
    fun bootstrapActions(argument: suspend ClusterBootstrapActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterBootstrapActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bootstrapActions = mapped
    }

    /**
     * @param values Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     */
    @JvmName("nebmwpjiaecinqxa")
    public suspend fun bootstrapActions(vararg values: ClusterBootstrapActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootstrapActions = mapped
    }

    /**
     * @param value List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
     */
    @JvmName("vaqtasjhlryampyy")
    public suspend fun configurations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value JSON string for supplying list of configurations for the EMR cluster.
     * > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const cluster = new aws.emr.Cluster("cluster", {configurationsJson: `[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * cluster = aws.emr.Cluster("cluster", configurations_json="""[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * """)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var cluster = new Aws.Emr.Cluster("cluster", new()
     *     {
     *         ConfigurationsJson = @"[
     * {
     * ""Classification"": ""hadoop-env"",
     * ""Configurations"": [
     * {
     * ""Classification"": ""export"",
     * ""Properties"": {
     * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
     * }
     * }
     * ],
     * ""Properties"": {}
     * }
     * ]
     * ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.NewCluster(ctx, "cluster", &emr.ClusterArgs{
     * 			ConfigurationsJson: pulumi.String(`[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.Cluster;
     * import com.pulumi.aws.emr.ClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .configurationsJson("""
     * [
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   cluster:
     *     type: aws:emr:Cluster
     *     properties:
     *       configurationsJson: |+
     *         [
     *         {
     *         "Classification": "hadoop-env",
     *         "Configurations": [
     *         {
     *         "Classification": "export",
     *         "Properties": {
     *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     *         }
     *         }
     *         ],
     *         "Properties": {}
     *         }
     *         ]
     * ```
     */
    @JvmName("vxsxltavfuchicrn")
    public suspend fun configurationsJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationsJson = mapped
    }

    /**
     * @param value Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
     */
    @JvmName("byosswkuryxusfgs")
    public suspend fun coreInstanceFleet(`value`: ClusterCoreInstanceFleetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreInstanceFleet = mapped
    }

    /**
     * @param argument Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
     */
    @JvmName("gognivoqnptibauy")
    public suspend
    fun coreInstanceFleet(argument: suspend ClusterCoreInstanceFleetArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterCoreInstanceFleetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.coreInstanceFleet = mapped
    }

    /**
     * @param value Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
     */
    @JvmName("fenjrxisikcyormi")
    public suspend fun coreInstanceGroup(`value`: ClusterCoreInstanceGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreInstanceGroup = mapped
    }

    /**
     * @param argument Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
     */
    @JvmName("akusynmywivdtbjv")
    public suspend
    fun coreInstanceGroup(argument: suspend ClusterCoreInstanceGroupArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterCoreInstanceGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.coreInstanceGroup = mapped
    }

    /**
     * @param value Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
     */
    @JvmName("bsviotgftuuxqtfq")
    public suspend fun customAmiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customAmiId = mapped
    }

    /**
     * @param value Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
     */
    @JvmName("lkvmmscowjxgwjjc")
    public suspend fun ebsRootVolumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsRootVolumeSize = mapped
    }

    /**
     * @param value Attributes for the EC2 instances running the job flow. See below.
     */
    @JvmName("avtupdiyratnvxnu")
    public suspend fun ec2Attributes(`value`: ClusterEc2AttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2Attributes = mapped
    }

    /**
     * @param argument Attributes for the EC2 instances running the job flow. See below.
     */
    @JvmName("ctqfnhgrhbjwbkug")
    public suspend fun ec2Attributes(argument: suspend ClusterEc2AttributesArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterEc2AttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ec2Attributes = mapped
    }

    /**
     * @param value Switch on/off run cluster with no steps or when all steps are complete (default is on)
     */
    @JvmName("xyqfpwlahovgwvpe")
    public suspend fun keepJobFlowAliveWhenNoSteps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepJobFlowAliveWhenNoSteps = mapped
    }

    /**
     * @param value Kerberos configuration for the cluster. See below.
     */
    @JvmName("namwyyarpwcijgmd")
    public suspend fun kerberosAttributes(`value`: ClusterKerberosAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosAttributes = mapped
    }

    /**
     * @param argument Kerberos configuration for the cluster. See below.
     */
    @JvmName("ggpnopldbyhuaoay")
    public suspend
    fun kerberosAttributes(argument: suspend ClusterKerberosAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterKerberosAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kerberosAttributes = mapped
    }

    /**
     * @param value List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     */
    @JvmName("grsemqtrfjytywdm")
    public suspend fun listStepsStates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listStepsStates = mapped
    }

    /**
     * @param values List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     */
    @JvmName("wjgokwvltoiyneho")
    public suspend fun listStepsStates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listStepsStates = mapped
    }

    /**
     * @param value AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    @JvmName("pkjdksywwovpjitp")
    public suspend fun logEncryptionKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logEncryptionKmsKeyId = mapped
    }

    /**
     * @param value S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
     */
    @JvmName("sewxhnthjnuhykbr")
    public suspend fun logUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logUri = mapped
    }

    /**
     * @param value Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
     */
    @JvmName("glkhqgxsvmnpkarc")
    public suspend fun masterInstanceFleet(`value`: ClusterMasterInstanceFleetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterInstanceFleet = mapped
    }

    /**
     * @param argument Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
     */
    @JvmName("fcdquqmdakpppkkw")
    public suspend
    fun masterInstanceFleet(argument: suspend ClusterMasterInstanceFleetArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterMasterInstanceFleetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.masterInstanceFleet = mapped
    }

    /**
     * @param value Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
     */
    @JvmName("lypgwlxofmhihyrv")
    public suspend fun masterInstanceGroup(`value`: ClusterMasterInstanceGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterInstanceGroup = mapped
    }

    /**
     * @param argument Configuration block to use an [Instance Group](https://docs&#46;aws&#46;amazon&#46;com/emr/latest/ManagementGuide/emr-instance-group-configuration&#46;html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
     */
    @JvmName("ixprqdrroblgjqqw")
    public suspend
    fun masterInstanceGroup(argument: suspend ClusterMasterInstanceGroupArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterMasterInstanceGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.masterInstanceGroup = mapped
    }

    /**
     * @param value Name of the job flow.
     */
    @JvmName("uimfwjipdinkckdn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("qcqonkstiawgyuly")
    public suspend fun placementGroupConfigs(`value`: List<ClusterPlacementGroupConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroupConfigs = mapped
    }

    /**
     * @param argument The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("etscpsbtsxltyjsh")
    public suspend
    fun placementGroupConfigs(argument: List<suspend ClusterPlacementGroupConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterPlacementGroupConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementGroupConfigs = mapped
    }

    /**
     * @param argument The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("mdecqfagekgkdfyh")
    public suspend fun placementGroupConfigs(
        vararg
        argument: suspend ClusterPlacementGroupConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterPlacementGroupConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementGroupConfigs = mapped
    }

    /**
     * @param argument The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("jqrbexylprwwxgud")
    public suspend
    fun placementGroupConfigs(argument: suspend ClusterPlacementGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterPlacementGroupConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementGroupConfigs = mapped
    }

    /**
     * @param values The specified placement group configuration for an Amazon EMR cluster.
     */
    @JvmName("erwkqnjsayohbrlj")
    public suspend fun placementGroupConfigs(vararg values: ClusterPlacementGroupConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementGroupConfigs = mapped
    }

    /**
     * @param value Release label for the Amazon EMR release.
     */
    @JvmName("mckualtpnquukhwn")
    public suspend fun releaseLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseLabel = mapped
    }

    /**
     * @param value Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
     */
    @JvmName("jiwwuchubqoeithp")
    public suspend fun scaleDownBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownBehavior = mapped
    }

    /**
     * @param value Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
     */
    @JvmName("pgxfuglpfndghkii")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value IAM role that will be assumed by the Amazon EMR service to access AWS resources.
     * The following arguments are optional:
     */
    @JvmName("ictatkvfmklsmqmf")
    public suspend fun serviceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
     */
    @JvmName("ynurodirnnwjgpxn")
    public suspend fun stepConcurrencyLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepConcurrencyLevel = mapped
    }

    /**
     * @param value List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("ccqiemxdosypvulm")
    public suspend fun steps(`value`: List<ClusterStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("yfbdflocdsamdtxy")
    public suspend fun steps(argument: List<suspend ClusterStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ClusterStepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("qimppurfcpfygwge")
    public suspend fun steps(vararg argument: suspend ClusterStepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ClusterStepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("vqscewmruuyjytld")
    public suspend fun steps(argument: suspend ClusterStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     */
    @JvmName("iqwklejcvikebgso")
    public suspend fun steps(vararg values: ClusterStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param value list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tvtwedyyywparedm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nfhobomkhqgydhwf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
     */
    @JvmName("myvfxcgbottqlvke")
    public suspend fun terminationProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationProtection = mapped
    }

    /**
     * @param value Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
     */
    @JvmName("psogtewtqwnsvmtl")
    public suspend fun visibleToAllUsers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibleToAllUsers = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        additionalInfo = additionalInfo,
        applications = applications,
        autoTerminationPolicy = autoTerminationPolicy,
        autoscalingRole = autoscalingRole,
        bootstrapActions = bootstrapActions,
        configurations = configurations,
        configurationsJson = configurationsJson,
        coreInstanceFleet = coreInstanceFleet,
        coreInstanceGroup = coreInstanceGroup,
        customAmiId = customAmiId,
        ebsRootVolumeSize = ebsRootVolumeSize,
        ec2Attributes = ec2Attributes,
        keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps,
        kerberosAttributes = kerberosAttributes,
        listStepsStates = listStepsStates,
        logEncryptionKmsKeyId = logEncryptionKmsKeyId,
        logUri = logUri,
        masterInstanceFleet = masterInstanceFleet,
        masterInstanceGroup = masterInstanceGroup,
        name = name,
        placementGroupConfigs = placementGroupConfigs,
        releaseLabel = releaseLabel,
        scaleDownBehavior = scaleDownBehavior,
        securityConfiguration = securityConfiguration,
        serviceRole = serviceRole,
        stepConcurrencyLevel = stepConcurrencyLevel,
        steps = steps,
        tags = tags,
        terminationProtection = terminationProtection,
        visibleToAllUsers = visibleToAllUsers,
    )
}
